// This class extends the Text class for the FSA Grammar
// to also be used in a Token Canvas

package fsa_editor;

import au.edu.monash.csse.tonyj.cider.interpreter.*;
import au.edu.monash.csse.tonyj.cider.canvas.DrawableToken;
import java.awt.Graphics2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;

public class DrawableText extends Text implements DrawableToken {

	// Private variables
	private int	halfWidth;
	private int	ascent;	
	private int	descent;	

	// Constructor
	public DrawableText(String label, double mid_x, double mid_y, boolean active, Color colour)
	{
		super(label, mid_x, mid_y, active, colour);
		halfWidth = ascent = descent = 0;
	}

	// Draw method
	public void draw(Graphics2D g2d)
	{
		String label = get_label();
		if (label.equals(""))
			label = "#";

		if (get_active())
			g2d.setColor(Color.blue);
		else
			g2d.setColor(Color.black);
		if (get_colour() != null)
			g2d.setColor(get_colour());
			
		g2d.setFont(new Font("Dialog", Font.PLAIN, 12));
		FontMetrics fm = g2d.getFontMetrics();
		halfWidth = fm.stringWidth(label) / 2;
		ascent = fm.getAscent();
		descent = fm.getDescent();
		g2d.drawString(label, (int) get_mid_x() - halfWidth, (int) get_mid_y());
		if (get_active()) {
			g2d.setColor(Color.red);
			g2d.fill(new Rectangle2D.Double(get_mid_x() - 1.0, get_mid_y() - 1.0, 3.0, 3.0));
		}
	}

	// Contains method
	public boolean contains(double x, double y)
	{
		int mid_x = (int) get_mid_x();
		int mid_y = (int) get_mid_y();
		return ((x >= mid_x - halfWidth) && (x <= mid_x + halfWidth) && (y >= (mid_y - ascent)) && (y <= mid_y + descent));
	}
}

