// A class to contain static methods

package fsa_editor;

import java.util.TreeSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import au.edu.monash.csse.tonyj.cider.interpreter.State;

public class Functions {

	public static int uniqueNum = 0;

	public static boolean OnCircle(double point_x, double point_y, double cmid_x, double cmid_y, double cradius, double tolerance)
	{
		double distance;

		// Calculate distance between cmid and point
		distance = Math.sqrt((point_x - cmid_x) * (point_x - cmid_x) +
			(point_y - cmid_y) * (point_y - cmid_y));

		// See if distance is equal to cradius (within tolerance amount)
		if (distance >= (cradius - tolerance) && distance <= (cradius + tolerance))
			return true;
		else
			return false;
	}

	public static boolean startsWith(String original, String prefix)
	{
		return original.startsWith(prefix);
	}

	public static String tail(String original, String prefix)
	{
		return original.substring(prefix.length());
	}

	public static double labelYOffset(double val1, double val2)
	{
		return (val1 + val2 + 12);
	}

	public static String uniqueStateName()
	{
		return ("s" + ++uniqueNum);
	}

	public static double doubleValue(double val)
	{
		return 2.0 * val;
	}

	public static double add(double val1, double val2)
	{
		return val1 + val2;
	}

	public static double average(double val1, double val2)
	{
		return (val1 + val2) / 2.0;
	}

	public static String cropExcessBrackets(String exp)
	{
		try {
			if (exp.charAt(0) == '(' && exp.charAt(exp.length()-1) == ')') {
				int level = 1;

				// See if level zero reached between outer parentheses
				for (int i = 1; i < exp.length() - 1; i++) {

					if (exp.charAt(i) == '(')
						level++;
					else if (exp.charAt(i) == ')')
						level--;

					// If level zero reached, outer parentheses are necessary
					if (level == 0)
						return exp;
				}

				// If we didn't return inside brackets, crop off
				// excess brackets and see if more need cropping
				exp = cropExcessBrackets(exp.substring(1, exp.length()-1));
			}
		}
		catch (IndexOutOfBoundsException e) { ; }
		return exp;
	}

	public static int getRegExpOp(String exp)
	{
		int levelZeroTerms = 0;
		int level = 0;
		boolean levelZeroOr = false;

		try {
			// Crop off any parentheses at the extremes if needed
			exp = cropExcessBrackets(exp);

			// If only one character (or less), cannot do anything
			if (exp.length() <= 1)
				return 0;

			// Count number of level zero terms
			for (int i = 0; i < exp.length(); i++) {

				if (exp.charAt(i) == '(')
					level++;
				else if (exp.charAt(i) == ')')
					level--;

				// Cannot have negative level
				if (level < 0)
					return 0;

				if (level == 0) {
					if (exp.charAt(i) == '|')
						levelZeroOr = true;
					else if (exp.charAt(i) != '*')
						levelZeroTerms++;
				}
			}

			// Make sure parentheses all match 
			if (level != 0)
				return 0;

			// Look for star operation
			if (levelZeroTerms == 1 && exp.charAt(exp.length()-1) == '*')
				return 1;

			// Look for disjunctions
			else if (levelZeroTerms > 1 && levelZeroOr)
				return 2;

			// Look for concatenation
			else if (levelZeroTerms > 1)
				return 3;
		}
		catch (IndexOutOfBoundsException e) { ; }
		return 0;
	}

	public static String getStarTerm(String exp)
	{
		try {
			// Crop off any parentheses at the extremes if needed
			exp = cropExcessBrackets(exp);

			// Assume last symbol is a star symbol
			return exp.substring(0, exp.length()-1);
		}
		catch (IndexOutOfBoundsException e) { ; }
		return "";
	}

	public static String getFirstDisjunctionTerm(String exp)
	{
		int i;
		int level = 0;

		try {
			// Crop off any parentheses at the extremes if needed
			exp = cropExcessBrackets(exp);

			// Find first level zero disjunction
			for (i = 0; i < exp.length(); i++) {

				if (exp.charAt(i) == '(')
					level++;
				else if (exp.charAt(i) == ')')
					level--;

				if (level == 0 && exp.charAt(i) == '|')
					break;
			}
			return exp.substring(0, i);
		}
		catch (IndexOutOfBoundsException e) { ; }
		return "";
	}

	public static String getSecondDisjunctionTerm(String exp)
	{   
		int i;
		int level = 0;

		try {
			// Crop off any parentheses at the extremes if needed
			exp = cropExcessBrackets(exp);

			// Find first level zero disjunction
			for (i = 0; i < exp.length(); i++) {

				if (exp.charAt(i) == '(')
					level++;
				else if (exp.charAt(i) == ')')
					level--;

				if (level == 0 && exp.charAt(i) == '|')
					break;
			}
			return exp.substring(i+1);
		}
		catch (IndexOutOfBoundsException e) { ; }
		return "";
	}

	public static String getFirstConcatenationTerm(String exp)
	{
		int i;
		int level = 0;

		try {
			// Crop off any parentheses at the extremes if needed
			exp = cropExcessBrackets(exp);

			// Find first level zero term ending
			for (i = 0; i < exp.length(); i++) {

				if (exp.charAt(i) == '(')
					level++;
				else if (exp.charAt(i) == ')')
					level--;

				if (level == 0)
					break;
			}

			// Check for stars after the term
			while (exp.charAt(i+1) == '*')
				i++;
			return exp.substring(0, i+1);
		}
		catch (IndexOutOfBoundsException e) { ; }
		return "";
	}

	public static String getSecondConcatenationTerm(String exp)
	{
		int i;
		int level = 0;

		try {
			// Crop off any parentheses at the extremes if needed
			exp = cropExcessBrackets(exp);

			// Find first level zero term ending
			for (i = 0; i < exp.length(); i++) {

				if (exp.charAt(i) == '(')
					level++;
				else if (exp.charAt(i) == ')')
					level--;

				if (level == 0)
					break;
			}

			// Check for stars after the term
			while (exp.charAt(i+1) == '*')
				i++;
			return exp.substring(i+1);
		}
		catch (IndexOutOfBoundsException e) { ; }
		return "";
	}

	// Used for minimizing DFA
	public static String mergeStateNames(String str1, String str2)
	{
		return str1 + "," + str2;
	}

	// Used for minimizing DFA
	public static boolean isMatchingStatePair(State sp1, State sp2, State m1, State m2)
	{
		if (sp1 == m1 && sp2 == m2)
			return true;
		if (sp1 == m2 && sp2 == m1)
			return true;
		return false;
	}
}

