/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Compiler Package
//
// Author:  Anthony R. Jansen
// Begun:   January 2003
// Class:   AttDependencyGraphNode
//
// This is a storage class for the 
// information needed for a node in the
// attribute dependency graph.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.compiler;

import java.util.Set;
import java.util.HashSet;

public class AttDependencyGraphNode {

	// Private variables
	private	String			name;
	private SymbolDefinition	symbol;
	private Attribute		attribute;
	private	int			setFrom;
	private Set			setBy;

	// Constants
	public static final int 	NOWHERE = 0;
	public static final int		ABOVE = 1;
	public static final int		BELOW = 2;

	// Constructor
	public AttDependencyGraphNode(SymbolDefinition sDef, Attribute att)
	{
		symbol = sDef;
		attribute = att;
		name = symbol.getName() + "." + attribute.getName();
		setFrom = NOWHERE;
		setBy = new HashSet();
	}

	// Returns the name of the symbol type
	public String getName()
	{
		return name;
	}

	// Returns the symbol definition
	public SymbolDefinition getSymbolDefinition()
	{
		return symbol;
	}

	// Returns the attribute
	public Attribute getAttribute()
	{
		return attribute;
	}

	// Returns where set from
	public int getSetFrom()
	{
		return setFrom;
	}

	// Adds a link 
	public void isSetBy(AttDependencyGraphNode node, int from)
	{
		if (setFrom == NOWHERE || setFrom == from) {
			setBy.add(node);
			setFrom = from;
		}
		else 
			Error.die(this, "Attribute \"" + name + "\" cannot be set as both an input and an output symbol");
	}

	// Returns the set of links
	public Set getSetBy()
	{
		return setBy;
	}
}

