/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Compiler Package
//
// Author:  Anthony R. Jansen
// Begun:   November 2002
// Class:   Attribute
//
// This class is just a storage structure
// for defining a symbol attribute.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.compiler;

public class Attribute {

	// Private variables
	private String	name;
	private String	datatype;
	private double	stayWeight;
	private double	editWeight;
	private boolean	constraintVariable;

	// Constructor
	public Attribute(String n, String dt, String ew, String sw, String lineNumber)
	{
		name = n;
		datatype = dt;
		constraintVariable = (dt.equals("ConstraintVariable") ? true : false);

		// Only interested in weight values if datatype is a constraint variable
		if (constraintVariable) {
			try {
				editWeight = Double.parseDouble(ew);
				stayWeight = Double.parseDouble(sw);
			}
			catch (NumberFormatException e) {
				Error.die(this, lineNumber, "Invalid weight specified for attribute " + name);
			}
		}
	}

	// Get methods
	public String getName()
	{
		return name;
	}

	public String getDataType()
	{
		return datatype;
	}

	public double getEditWeight()
	{
		return editWeight;
	}

	public double getStayWeight()
	{
		return stayWeight;
	}

	// Returns true iff the datatype is a constraint variable
	public boolean isConstraintVariable()
	{
		return constraintVariable;
	}
}

