/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Compiler Package
//
// Author:  Anthony R. Jansen
// Begun:   October 2002
// Class:   DOMParserLN
//
// This class extends the DOM Parser to 
// also provide line number information as
// and element attribute.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.compiler;

import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.utils.QName;
import org.apache.xerces.framework.XMLAttrList;
import org.xml.sax.SAXException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class DOMParserLN extends DOMParser {

	// Constructor
	public DOMParserLN()
	{
		super();
		try {
			setDeferNodeExpansion(false);
		}
		catch (SAXException e) {
			Error.die(this, e.toString());
		}
	}

	// Override the startElement method
	public void startElement(QName elementQName, XMLAttrList xmlAttrList, int attrListIndex)
	{
		try {
			int lineNumber = getLocator().getLineNumber();
			super.startElement(elementQName, xmlAttrList, attrListIndex);
			Element current = getCurrentElementNode();
			if (current != null) 
				current.setAttribute("_line_number_", "" + lineNumber);
		}
		catch (SAXException e) {
			Error.die(this, e.toString());
		}
		catch (DOMException e) {
			Error.die(this, e.toString());
		}
		catch (Exception e) {
			Error.die(this, e.toString());
		}
	}
}

