/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Compiler Package
//
// Author:  Anthony R. Jansen
// Begun:   November 2002
// Class:   DependencyGraphNode
//
// This is a storage class for the 
// information needed for a node in a
// dependency graph.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.compiler;

import java.util.Set;
import java.util.HashSet;

public class DependencyGraphNode {

	// Private variables
	private SymbolDefinition	symbol;
	private Set			reductionLinks;
	private Set			positiveExistentialLinks;
	private Set			negativeExistentialLinks;

	// Constructor
	public DependencyGraphNode(SymbolDefinition sDef)
	{
		symbol = sDef;
		reductionLinks = new HashSet();
		positiveExistentialLinks = new HashSet();
		negativeExistentialLinks = new HashSet();
	}

	// Returns the name of the symbol type
	public String getSymbolType()
	{
		return symbol.getName();
	}

	// Returns the symbol definition
	public SymbolDefinition getSymbolDefinition()
	{
		return symbol;
	}

	// Adds a reduction link 
	public void addReductionDependency(DependencyGraphNode node)
	{
		reductionLinks.add(node);
	}

	// Adds a positive existential link 
	public void addPositiveExistentialDependency(DependencyGraphNode node)
	{
		positiveExistentialLinks.add(node);
	}

	// Adds a negative existential link 
	public void addNegativeExistentialDependency(DependencyGraphNode node)
	{
		negativeExistentialLinks.add(node);
	}

	// Returns the set of reduction links
	public Set getReductionDependencies()
	{
		return reductionLinks;
	}

	// Returns the set of positive existential links
	public Set getPositiveExistentialDependencies()
	{
		return positiveExistentialLinks;
	}

	// Returns the set of negative existential links
	public Set getNegativeExistentialDependencies()
	{
		return negativeExistentialLinks;
	}
}

