/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Compiler Package 
//
// Author:  Anthony R. Jansen
// Begun:   November 2002
// Class:   Error
//
// This class implements error handling
// for the compiler.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.compiler;

public class Error {

	// Flag to suppress warnings
	public static boolean warningsOn = true;

	// Fatal Error method to kill the program
	public static void die(Object obj, String desc)
	{
		System.err.println("--- Fatal Error ---");
		System.err.println("   Class: " + obj.getClass().getName());
		System.err.println("   Description: " + desc);
		System.exit(1);
	}

	// Fatal Error method to kill the program, noting line number
	public static void die(Object obj, String lineNumber, String desc)
	{
		System.err.println("--- Fatal Error ---");
		System.err.println("   Class: " + obj.getClass().getName());
		System.err.println("   Input File Line Number: " + lineNumber);
		System.err.println("   Description: " + desc);
		System.exit(1);
	}

	// Warning method
	public static void warn(Object obj, String desc)
	{
		if (warningsOn) {
			System.err.println("--- Warning ---");
			System.err.println("   Class: " + obj.getClass().getName());
			System.err.println("   Description: " + desc);
		}
	}
}

