/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Token Canvas Package
//
// Author:    Anthony R. Jansen
// Begun:     November 2002
// Interface: DrawableToken
//
// This is the interface that needs to be
// implemented when creating tokens that 
// can be drawn on the token canvas.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.canvas;

import java.awt.Graphics2D;

/**
 * This interface must be implemented by all classes that represent
 * drawable tokens that are to be used by the {@link TokenCanvas}.
 */
public interface DrawableToken {

	/**
	 * Draws the token.
	 * @param g2 The graphics context to be drawn to.
	 */
	public void draw(Graphics2D g2);

	/**
	 * Determine if the specifies co-ordinates lie with the token.
	 * @param x The x co-ordinate.
	 * @param y The y co-ordinate.
	 * @return <code>true</code> if and only if the co-ordinates lie with the token.
	 */
	public boolean contains(double x, double y);
}

