/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Solver Constraints Package
//
// Author:    Anthony R. Jansen
// Begun:     November 2002
// Interface: ConstraintVariable
//
// This is the interface that defines how a
// constraint variable implementation needs 
// to be accessed.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.constraints;

/**
 * Constraint variables are used in {@link Constraint}s and {@link ConstraintExpression}s.
 * This interface defines how a constraint variable is manipulated. Classes that
 * implement this interface should also define a no-argument constructor.
 */
public interface ConstraintVariable {

	/**
	 * Set the goal value for this variable.
	 * @param value The goal value.
	 */
	public void setDesiredValue(double value);

	/**
	 * Returns the goal value for this variable.
	 */
	public double getDesiredValue();

	/**
	 * Returns the solved value for this variable. 
	 */
	public double getSolvedValue();

	/**
	 * Sets the edit weight of this variable.
	 * @param weight Weight value.
	 */
	public void setEditWeight(double weight);

	/**
	 * Returns the edit weight of this variable.
	 */
	public double getEditWeight();

	/**
	 * Sets the stay weight of this variable.
	 * @param weight Weight value.
	 */
	public void setStayWeight(double weight);

	/**
	 * Returns the stay weight of this variable.
	 */
	public double getStayWeight();
}

