/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Solver Constraints Package
//
// Author:  Anthony R. Jansen
// Begun:   November 2002
// Class:   ConstraintVariableEvent
//
// This class is used for specifying events
// that happen to Constraint Variables.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.constraints;

import java.util.EventObject;

/**
 * This class contains the information detailing an event that
 * has occurred which involves a {@link ConstraintVariable}. 
 */
public class ConstraintVariableEvent extends EventObject {

	// Private variables
	private	ConstraintVariable	variable;
	private int			eventType;
	private Double			oldValue;

	/**
	 * Constant to indicate that the type of event is the modification of the solved value of a variable.
	 */
	public static final int VARIABLE_MODIFIED = 1;

	/**
	 * Creates a new ConstraintVariableEvent object.
	 * @param source The object that created the event.
	 * @param cv The constraint variable that the event involves.
	 * @param type The type of event.
	 * @param ov The old solved value of the constraint variable involed.
	 */
	public ConstraintVariableEvent(Object source, ConstraintVariable cv, int type, Double ov)
	{
		super(source);
		variable = cv;
		eventType = type;
		oldValue = ov;
	}

	/**
	 * Returns the constraint variable that was modified.
	 */
	public ConstraintVariable getConstraintVariable()
	{
		return variable;
	}

	/**
	 * Returns the type of event.
	 */
	public int getEventType()
	{
		return eventType;
	}

	/**
	 * Returns the old solved value of the constraint variable that was modified.
	 */
	public Double getOldValue()
	{
		return oldValue;
	}
}

