/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Interpreter Package
//
// Author:  Anthony R. Jansen
// Begun:   June 2003
// Class:   CiderFormatter
//
// This class defines the format to be used
// for logging by the CIDER interpreter.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.interpreter;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Handler;

class CiderFormatter extends Formatter {

	// Start time
	private long	startTime;
	private String	newline;
	private String	head;

	// Constructor
	public CiderFormatter(long st, String h)
	{
		newline = System.getProperty("line.separator");
		startTime = st;
		head = h;
	}

	// Implement format method
	public String format(LogRecord record)
	{
		String string = "----------" + newline;
		string += "Log entry: " + record.getSequenceNumber() + newline; 
		string += "Time:      " + (record.getMillis() - startTime) + "ms" + newline;
		string += "Level:     " + record.getLevel().getName() + newline;
		string += "Class:     " + record.getSourceClassName() + newline;
		string += "Method:    " + record.getSourceMethodName() + newline;
		if (record.getThrown() != null)
			string += "Throwable: " + record.getThrown().toString() + newline;
		string += "Message:   " + formatMessage(record) + newline;
		return string;
	}

	// Override the getHead method
	public String getHead(Handler handler)
	{
		return head + newline;
	}
}

