/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Interpreter Package
//
// Author:  Anthony R. Jansen
// Begun:   September 2002
// Class:   ExampleSymbol
//
// This class is purely for the purposes
// of adding an example of how a specific
// grammar symbol class produced by the
// CIDER Compiler would look. It exists
// to allow example Javadocs to be 
// generated.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.interpreter;

import au.edu.monash.csse.tonyj.cider.constraints.*;
import java.util.Set;
import java.util.HashSet;

/**
 * <center><b> IMPORTANT: THIS IS NOT A REAL CLASS - IT IS AN EXAMPLE ONLY </b></center> <br> 
 * This class is an example of what a symbol class produced by the <b>CIDER</b> Compiler would look like. <br><br>
 * The example symbol type that this class represents contains three attributes, named <i>attribute1</i>, <i>attribute2</i> and
 * <i>attribute3</i>. They are an <code>int</code>, a <code>ConstraintVariable</code> and a <code>String</code> repsectively.
 * Each attribute has <i>get</i> and <i>set</i> methods of the form <code>get_<i>attribute_name</i></code> and 
 * <code>set_<i>attribute_name</i></code>. <br><br>
 * Note that the <code>ConstraintVariable</code> attribute is treated in its <i>get</i> and <i>set</i>
 * methods as though its datatype is a <code>double</code>.<br><br>
 * (If the symbol inherits from an abstract symbol type, the attributes of the abstract symbol will also
 * be accessible via <i>get</i> and <i>set</i> methods as described above.)
 */
public class ExampleSymbol extends GrammarSymbol {

	// Private variables
	private	int	_attribute1;
	private double	_attribute2;
	private String	_attribute3;

	/**
	 * Constructor to create an instance of the symbol. Initial values for all of the symbol attributes must be passed to the constructor.
	 * Note that initial values for <code>ConstraintVariable</code> attributes are passed as <code>double</code> values.<br>
	 * <b>Important:</b> if the symbol is a non-terminal symbol, no <code>public</code> constructor will be available.
	 */
	public ExampleSymbol(int init_attribute1, double init_attribute2, String init_attribute3)
	{
		super(true);
		_attribute1 = init_attribute1;
		_attribute2 = init_attribute2;
		_attribute3 = init_attribute3;
	}

	/**
	 * Returns the value of <i>attribute1</i>.
	 */
	public int get_attribute1()
	{
		return _attribute1;
	}

	/**
	 * Returns the value of <i>attribute2</i>. 
	 * Note that even though this attribute is a <code>ConstraintVariable</code>, its value is returned as a <code>double</code>. 
	 */
	public double get_attribute2()
	{
		return _attribute2;
	}

	/**
	 * Returns the value of <i>attribute3</i>.
	 */
	public String get_attribute3()
	{
		return _attribute3;
	}

	/**
	 * Allows the value of <i>attribute1</i> to be set.
	 * If the symbol is associated with an {@link Interpreter}, then this method will automatically inform the Interpreter
	 * of its new value which may result in other changes to the Interpreter's parse forest. 
	 */
	public void set_attribute1(int value)
	{
		_attribute1 = value;
	}

	/**
	 * Allows the value of <i>attribute2</i> to be set.
	 * Note that even though this attribute is a <code>ConstraintVariable</code>, its value is returned as a <code>double</code>. 
	 * If the symbol is associated with an {@link Interpreter}, then this method will automatically inform the Interpreter
	 * of its new value which may result in other changes to the Interpreter's parse forest. 
	 */
	public void set_attribute2(double value)
	{
		_attribute2 = value;
	}

	/**
	 * Allows the value of <i>attribute3</i> to be set.
	 * If the symbol is associated with an {@link Interpreter}, then this method will automatically inform the Interpreter
	 * of its new value which may result in other changes to the Interpreter's parse forest. 
	 */
	public void set_attribute3(String value)
	{
		_attribute3 = value;
	}

	/**
	 * Returns the name of this symbol type. In this case it will return <code>"ExampleSymbol"</code>.
	 */
	public String getName()
	{
		return "ExampleSymbol";
	}

	/**
	 * Returns a string representation of this symbol, which includes its attribute values.
	 */
	public String toString()
	{
		return "Symbol " + getIDNumber() + ": ExampleSymbol [attribute1 = \"" + get_attribute1() + "\", " +
			"attribute2 = \"" + get_attribute2() + "\", " +
			"attribute3 = \"" + get_attribute3() + "\"]";
	}

	// Package scope method (required)
	int getAttributeIdentifier(ConstraintVariable var) { return 0; }
	String getAttributeName(int identifier) { return ""; }
	Set getConstraintVariables() { return new HashSet(); }
	void restoreAttributeValue(int attribute, Object value) { }
}

