/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Interpreter Package
//
// Author:  Anthony R. Jansen
// Begun:   September 2002
// Class:   GrammarSymbolEvent
//
// This class is used for specifying events
// that happen to Grammar Symbols.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.interpreter;

import java.util.EventObject;

/**
 * This class contains the information detailing an event that
 * has occurred which involves a {@link GrammarSymbol}. 
 */
public class GrammarSymbolEvent extends EventObject {

	// Private variables
	private	GrammarSymbol	symbol;
	private int		eventType;

	/**
	 * Constant to indicate that the type of event is the addition of a grammar symbol 
	 * to the internal parse forest of an {@link Interpreter}.
	 */
	public static final int SYMBOL_ADDED = 1;

	/**
	 * Constant to indicate that the type of event is the removal of a grammar symbol 
	 * from the internal parse forest of an {@link Interpreter}.
	 */
	public static final int SYMBOL_REMOVED = 2;

	/**
	 * Constant to indicate that the type of event is the modification of a grammar symbol 
	 * which is part of the internal parse forest of an {@link Interpreter}.
	 */
	public static final int SYMBOL_MODIFIED = 3;

	/**
	 * Creates a new GrammarSymbolEvent object.
	 * @param source The object that created the event.
	 * @param gs The grammar symbol that the event involves.
	 * @param type The type of event.
	 */
	public GrammarSymbolEvent(Object source, GrammarSymbol gs, int type)
	{
		super(source);
		symbol = gs;
		eventType = type;
	}

	/**
	 * Returns the grammar symbol involved in the event.
	 */
	public GrammarSymbol getGrammarSymbol()
	{
		return symbol;
	}

	/**
	 * Returns the type of event.
	 */
	public int getEventType()
	{
		return eventType;
	}
}

