/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Interpreter Package
//
// Author:    Anthony R. Jansen
// Begun:     September 2002
// Interface: GrammarSymbolListener
//
// This is the interface that needs to be
// implemented to listen for Grammar
// Symbol related events.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.interpreter;

import java.util.EventListener;

/**
 * This interface must be implemented to listen for events
 * that involve {@link GrammarSymbol}s that are being used by an {@link Interpreter}.
 */
public interface GrammarSymbolListener extends EventListener {

	/**
	 * This method is called when a grammar symbol has been added to the internal parse 
	 * forest of the {@link Interpreter}.
	 * @param event Contains details of the event.
	 */
	public void symbolAdded(GrammarSymbolEvent event);
	
	/**
	 * This method is called when a grammar symbol has been removed from the internal parse 
	 * forest of the {@link Interpreter}.
	 * @param event Contains details of the event.
	 */
	public void symbolRemoved(GrammarSymbolEvent event);

	/**
	 * This method is called when a grammar symbol that is in the internal parse 
	 * forest of the {@link Interpreter} is modified.
	 * @param event Contains details of the event.
	 */
	public void symbolModified(GrammarSymbolEvent event);
}

