/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Interpreter Package
//
// Author:  Anthony R. Jansen
// Begun:   June 2003
// Class:   Log
//
// This class handles dealings with Java's
// inbuilt logging functionality.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.interpreter;

import java.util.Date;
import java.text.DateFormat;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.Level;
import java.util.logging.Handler;
import java.util.logging.FileHandler;

class Log {

	// This method will create a logger with the appropriate handler and formatting
	// if it does not yet exist, and simply returns that logger if it does exist
	public static Logger getLogger()
	{
		Logger logger = LogManager.getLogManager().getLogger("au.edu.monash.csse.tonyj.cider.interpreter");

		// Set up new logger if required 
		if (logger == null) {

			logger = Logger.getLogger("au.edu.monash.csse.tonyj.cider.interpreter");	
			logger.setLevel(Level.INFO);
			logger.setUseParentHandlers(false);
			try {
				// Log records stored using two rotating 5 meg files
				long currentTime = System.currentTimeMillis();
				Date currentDate = new Date(currentTime);
				String logHeader = "CIDER Interpreter Log" + System.getProperty("line.separator") + 
					"(CIDER Version " + Interpreter.VERSION + ")" + System.getProperty("line.separator") +
					"Date: " + DateFormat.getDateInstance(DateFormat.LONG).format(currentDate) + 
					System.getProperty("line.separator") +
					"Time: " + DateFormat.getTimeInstance(DateFormat.LONG).format(currentDate);
				Handler handler = new FileHandler("cider%g.log", 1024 * 1024 * 5, 2);
				handler.setFormatter(new CiderFormatter(currentTime, logHeader));
				handler.setLevel(Level.ALL);
				logger.addHandler(handler);
			}
			catch (Exception e) { 
				Error.warn("Logging Handler could not be created: " + e.toString());
			}
		}
		return logger;
	}
}

