/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Interpreter Package
//
// Author:  Anthony R. Jansen
// Begun:   September 2002
// Class:   ProductionNode
//
// This class represents a production node 
// in the parse forest. Production nodes 
// link to symbol nodes in a parse tree, 
// which in turn link to other production
// nodes.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.interpreter;

import java.util.Set;

class ProductionNode {

	// Private production record
	private ProductionRecord	record;
	private int			level;

	// Constructor
	public ProductionNode(ProductionRecord r, int l)
	{
		record = r;
		level = l;
		record.setProductionNode(this);
	}

	// Returns the production record associated with this node
	public ProductionRecord getRecord()
	{
		return record;
	}

	// Returns the set of input symbol nodes for the production associated with this node
	public Set getInputSymbolNodes()
	{
		return record.getInputSymbolNodes();
	}

	// Returns the set of output symbol nodes for the production associated with this node
	public Set getOutputSymbolNodes()
	{
		return record.getOutputSymbolNodes();
	}

	// Returns the level of this production node
	public int getLevel()
	{
		return level;
	}

	// Log message when finalized
	public void finalize() throws Throwable
	{
		Log.getLogger().finest("Production Node finalized");
	}
}

