/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Interpreter Package
//
// Author:  Anthony R. Jansen
// Begun:   September 2002
// Class:   ProductionNodeComparator
//
// This is a simple comparator to allow
// production nodes to be sorted in a list
// according to their level value.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.interpreter;

import java.util.Comparator;

class ProductionNodeComparator implements Comparator {

	// Override the compare function
	public int compare(Object o1, Object o2) throws ClassCastException
	{
		ProductionNode node1 = (ProductionNode) o1;
		ProductionNode node2 = (ProductionNode) o2;

		// For equal levels, order according to ID number
		int offset = 0;
		if (node1.getRecord().getIDNumber() < node2.getRecord().getIDNumber())
			offset = -1;
		else if (node1.getRecord().getIDNumber() > node2.getRecord().getIDNumber())
                        offset = 1;

		return (2 * (node1.getLevel() - node2.getLevel())) + offset;
	}
}

