/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Interpreter Package
//
// Author:    Anthony R. Jansen
// Begun:     September 2002
// Interface: SymbolNodeSets
//
// For a specific grammar, symbols in the
// parse tree need to be grouped together 
// into sets with other symbols of the same 
// type. This results in a collection of 
// sets, one for each symbol type. This 
// interface  is used to define the 
// non-grammar specific functionality of 
// such a collection of sets. 
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.interpreter;

import au.edu.monash.csse.tonyj.cider.constraints.ConstraintSolver;
import java.util.Set;
import java.io.PrintStream;

interface SymbolNodeSets {

	// Empties all the symbol node sets
	public void clear();

	// Adds a symbol node
	public void add(SymbolNode node);
	
	// Adds the contents of another symbol node sets 
	public void addAll(SymbolNodeSets sns);

	// Removes a symbol node
	public void remove(SymbolNode node);

	// Prints the set contents
	public void print(PrintStream stream);

	// Returns true iff sets contain the specified symbol node
	public boolean contains(SymbolNode node);

	// Sets the interpreter - used when a serialized object is restored
	public void setInterpreter(Interpreter inter);

	// Returns a set containing all the symbols
	public Set getSymbols();
}

