/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Interpreter Package
//
// Author:    Anthony R. Jansen
// Begun:     February 2004
// Class:     TransformationRuleFDLayout
//
// This is a transformation rule for 
// calling force directed layout on the
// current diagram.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.interpreter;

import au.edu.monash.csse.tonyj.cider.constraints.ConstraintSolver;

class TransformationRuleFDLayout implements TransformationRule {

	// Private variables
	private ParseForest	forest;
	private	boolean		alreadyApplied;

	// Constructor
	public TransformationRuleFDLayout(ParseForest f, ConstraintSolver cs)
	{
		forest = f;
		alreadyApplied = false;
	}

	// Apply layout
	public boolean normalApply()
	{
		// Return success the first time only (to allow undoing of rule if needed)
		if (alreadyApplied) 
			return false;

		forest.getInterpreter().applyForceDirectedLayout(10);

		alreadyApplied = true;
		return true;
	}

	// Don't distinguish between normal and parallel for layout
	public boolean parallelApply()
	{
		return normalApply();
	}
}

