/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Interpreter Package
//
// Author:  Anthony R. Jansen
// Begun:   March 2003
// Class:   UndoAddTerminalSymbol
//
// This class represents an undo record
// that allows an add terminal symbol
// action to be undone.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.interpreter;

class UndoAddTerminalSymbol implements UndoRecord {

	// Private variables
	private ParseForest		forest;
	private GrammarSymbol		symbol;

	// Constructor
	public UndoAddTerminalSymbol(ParseForest f, GrammarSymbol s)
	{
		forest = f;
		symbol = s;
	}

	// Implementation of undo method
	public boolean undo()
	{
		return forest.removeTerminalSymbol(symbol);
	}
}

