/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Layout Package
//
// Author:  Anthony R. Jansen
// Begun:   February 2004
// Class:   ForceVector
//
// A simple 2D force vector with some basic
// manipulation operations.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.layout;

import java.io.Serializable;

class ForceVector implements Serializable {

	double	dx;
	double	dy;

	// Default Constructor
	ForceVector()
	{
		dx = 0.0;
		dy = 0.0;
	}

	// Constructor
	ForceVector(double x, double y)
	{
		dx = x;
		dy = y;
	}

	void add(ForceVector v)
	{
		dx += v.dx;
		dy += v.dy;
	}

	void reset()
	{
		dx = 0.0;
		dy = 0.0;
	}

	void set(double x, double y)
	{
		dx = x;
		dy = y;
	}

	void negate()
	{
		dx = -dx;
		dy = -dy;
	}

	void scale(double s)
	{
		dx *= s;
		dy *= s;
	}
}

