/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Layout Package
//
// Author:  Anthony R. Jansen
// Begun:   February 2004
// Class:   GELayoutNode
//
// This class maps a GraphEdgeInt object to
// a Layout Node (using the mid point of 
// the edge as the node location), which
// used by the force directed layout system
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.layout;

class GELayoutNode extends LayoutNode {

	private GraphEdgeInt edge;

	// Constructor
	GELayoutNode(GraphEdgeInt e, boolean modifiable)
	{
		super(modifiable);
		edge = e;
	}

	double getX()
	{
		return edge.get_mid_x();
	}

	double getY()
	{
		return edge.get_mid_y();
	}

	double getWidth()
	{
		return 2.0;
	}

	double getHeight()
	{
		return 2.0;
	}

	void adjustPosition()
	{
		double newX = edge.get_mid_x() + v.dx;
		double newY = edge.get_mid_y() + v.dy;
		edge.set_mid_x(newX);
		edge.set_mid_y(newY);
	}

	GraphEdgeInt getGraphEdgeInt()
	{
		return edge;
	}
}

