/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Layout Package
//
// Author:  Anthony R. Jansen
// Begun:   February 2004
// Class:   GNLayoutNode
//
// This class maps a GraphNodeInt object to
// a Layout Node used by the force directed
// layout system.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.layout;

class GNLayoutNode extends LayoutNode {

	private GraphNodeInt node;

	// Constructor
	GNLayoutNode(GraphNodeInt n, boolean modifiable)
	{
		super(modifiable);
		node = n;
	}

	double getX()
	{
		return node.get_mid_x();
	}

	double getY()
	{
		return node.get_mid_y();
	}

	double getWidth()
	{
		return node.get_width();
	}

	double getHeight()
	{
		return node.get_height();
	}

	void adjustPosition()
	{
		double newX = node.get_mid_x() + v.dx;
		double newY = node.get_mid_y() + v.dy;
		node.set_mid_x(newX);
		node.set_mid_y(newY);
	}

	GraphNodeInt getGraphNodeInt()
	{
		return node;
	}
}

