/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Layout Package
//
// Author:     Anthony R. Jansen
// Begun:      February 2004
// Interface:  GraphEdgeInt
//
// Interface for a graph edge class that
// will be created by the CIDER compiler.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.layout;

public interface GraphEdgeInt {

	public double get_mid_x();
	public double get_mid_y();

	public GraphNodeInt get_node1();
	public GraphNodeInt get_node2();

	public void set_mid_x(double value);
	public void set_mid_y(double value);
}

