/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: Layout Package
//
// Author:  Anthony R. Jansen
// Begun:   February 2004
// Class:   LayoutNode
//
// An abstract class that represents a
// node used in force directed layout.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.layout;

import java.util.Vector;

abstract class LayoutNode {

	private boolean	modifiable;
	ForceVector	v;
	Vector		connectedTo;

	// Constructor
	LayoutNode(boolean m)
	{
		modifiable = m;
		connectedTo = new Vector();
		v = new ForceVector();
	}

	abstract double getX();
	
	abstract double getY();

	abstract double getWidth();

	abstract double getHeight();

	abstract void adjustPosition();

	boolean isModifiable()
	{
		return modifiable;
	}
}

