/*
    Copyright (C) 2003  Anthony R. Jansen.

    This file is part of the CIDER Toolkit.

    The CIDER Toolkit is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The CIDER Toolkit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the CIDER Toolkit; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// ----------------------------------------
// CIDER Toolkit: QOCA Implementation
//
// Author:    Anthony R. Jansen
// Begun:     December 2002
// Class:     QocaConstraintVariable
//
// This class implements the Qoca 
// constraint variable using the 
// constraints package interface.
// ----------------------------------------

package au.edu.monash.csse.tonyj.cider.qoca;

import au.edu.monash.csse.tonyj.cider.constraints.*;

public class QocaConstraintVariable implements ConstraintVariable {

	// Private variable
	private qoca.QcFloat	variable;

	// Constructor
	public QocaConstraintVariable()
	{
		variable = new qoca.QcFloat("v", 0.0, 10.0, 1000.0);
	}	

	// Set the goal value for this variable
	public void setDesiredValue(double value)
	{
		variable.suggestValue(value);
	}

	// Returns the goal value for this variable
	public double getDesiredValue()
	{
		return variable.getDesiredValue();
	}

	// Returns the solved value for this variable
	public double getSolvedValue()
	{
		return variable.getSolvedValue();
	}

	// Set the edit weight of this variable
	public void setEditWeight(double weight) 
	{ 
		variable.setEditWeight(weight);
	}

	// Get the edit weight of this variable
	public double getEditWeight() 
	{ 
		return variable.getEditWeight(); 
	}

	// Set the stay weight of this variable
	public void setStayWeight(double weight) 
	{ 
		variable.setStayWeight(weight);
	}

	// Get the stay weight of this variable
	public double getStayWeight() 
	{ 
		return variable.getStayWeight(); 
	}

	// Returns the variable
	public qoca.QcFloat getQcFloat()
	{
		return variable;
	}
}

