### Warning: this will only work with Makefile builds

TEMPLATE = app
LANGUAGE = C++

# On Mac OS X and Windows, use "Digest" as the target name.
# However, on UNIX systems other than Mac OS X, use "digest" (i.e. lowercase),
# as it`s more often typed in via a terminal/console rather than double-clicked.
unix:!macx {
	TARGET = digest
} else {
	TARGET = Digest
}
DESTDIR = ../../bin/ ### Note: the "bin" directory will be created automatically


### INCLUDE THE CONFIG
include( ../../config.pri ) ### Warning! we must set TEMPLATE and TARGET before we do this

CONFIG	+= qt uic resources warn_on  ### Warning! release/debug is set by config.pri
QT      += xml sql

# Define useful names and paths
## WARNING: DESTDIR_TARGET does not seem to work...
macx {
        APP_CONTENTS_DIR     = $${DESTDIR}/$${TARGET}.app/Contents
	COMPLETE_TARGET_NAME = $${APP_CONTENTS_DIR}/MacOS/$${TARGET}
        APP_RES_DIR          = $${APP_CONTENTS_DIR}/Resources
	APP_LIBS_DIR         = $${APP_CONTENTS_DIR}/Resources
} else {
	COMPLETE_TARGET_NAME = $${DESTDIR}/$${TARGET}
}

macx:RC_FILE = mac/Digest.icns
macx:QMAKE_POST_LINK = sh postlinkscript_mac.sh

unix {
  UI_DIR = .ui
  MOC_DIR = .moc
  OBJECTS_DIR = .obj
}


# LIBRARY: Java Virtual Machine
# TODO: make this system independant!
INCLUDEPATH += /System/Library/Frameworks/JavaVM.framework/Headers
LIBS += -framework JavaVM


# LIBRARY HEADER FILES
DEPENDPATH += ../include
INCLUDEPATH += ../include


# LIBRARY: Gesture
PRE_TARGETDEPS += ../Gesture/libGesture.dylib
LIBS += ../Gesture/libGesture.dylib
include( ../include/Gesture/paths.pri )

# LIBRARY: MvcCore
PRE_TARGETDEPS += ../MvcCore/libMvcCore.dylib
LIBS += ../MvcCore/libMvcCore.dylib
include( ../include/MvcCore/paths.pri )

# LIBRARY: MvcDigestDb
PRE_TARGETDEPS += ../MvcDigestDb/libMvcDigestDb.dylib
LIBS += ../MvcDigestDb/libMvcDigestDb.dylib
include( ../include/MvcDigestDb/paths.pri )

# LIBRARY: MvcSettings
PRE_TARGETDEPS += ../MvcSettings/libMvcSettings.dylib
LIBS += ../MvcSettings/libMvcSettings.dylib
include( ../include/MvcSettings/paths.pri )

# LIBRARY: WidgetPack
PRE_TARGETDEPS += ../WidgetPack/libWidgetPack.dylib
LIBS += ../WidgetPack/libWidgetPack.dylib
include( ../include/WidgetPack/paths.pri )

# LIBRARY: DigestGuiCore
PRE_TARGETDEPS += ../DigestGuiCore/libDigestGuiCore.dylib
LIBS += ../DigestGuiCore/libDigestGuiCore.dylib
include( ../include/DigestGuiCore/paths.pri )

# LIBRARY: GestureRecognition
PRE_TARGETDEPS += ../GestureRecognition/libGestureRecognition.dylib
LIBS += ../GestureRecognition/libGestureRecognition.dylib
include( ../include/GestureRecognition/paths.pri )

# LIBRARY: MvcDiagram
PRE_TARGETDEPS += ../MvcDiagram/libMvcDiagram.dylib
LIBS += ../MvcDiagram/libMvcDiagram.dylib
include( ../include/MvcDiagram/paths.pri )


DEPENDPATH  += . \
               .. \
               controllers \
               views
INCLUDEPATH += . \
               .. \
               controllers \
               views

HEADERS += ../sharedmacros.h \
           digest.h \
           digestactionmanager.h \
           digestapplication.h \
           mdiapplication.h \
           controllers/digestcontrollerthreadhost.h \
           controllers/fsadiagramcontroller.h \
           controllers/guidiagramcontroller.h \
           views/diagrameditor.h \
           views/elementinspector.h \
           views/mdidiagramwindow.h \
           views/digestprefsdialog.h \
           views/toolchooser.h

FORMS += aboutboxform.ui \
         views/digestprefsdialogform.ui

SOURCES += digestactionmanager.cpp \
           digestapplication.cpp \
           main.cpp \
           controllers/fsadiagramcontroller.cpp \
           controllers/guidiagramcontroller.cpp \
           views/diagrameditor.cpp \
           views/elementinspector.cpp \
           views/mdidiagramwindow.cpp \
           views/digestprefsdialog.cpp

RESOURCES += Digest.qrc
