#!/bin/sh

echo Executing CIDER on fsa.grammar with fsa.transformations ...
java -jar CiderCompiler-0.3.0.jar -g fsa.grammar -t fsa.transformations
echo done.
echo

echo Compiling Java code ...
javac -classpath .:CiderCore-0.3.0.jar au/edu/monash/csse/tonyj/cider/interpreter/*.java fsa_editor/*.java
echo done.
echo

mkdir -p .build_tmp/au/edu/monash/csse/tonyj/cider/interpreter
mkdir -p .build_tmp/fsa_editor

echo Copying class files ...
cp -rf au/edu/monash/csse/tonyj/cider/interpreter/*.class .build_tmp/au/edu/monash/csse/tonyj/cider/interpreter
cp -rf fsa_editor/*.class .build_tmp/fsa_editor
echo done.
echo

echo Creating fsa_editor.jar ...
cd .build_tmp
jar cf ../fsa_editor.jar au fsa_editor
cd ..
echo done.
echo

echo Cleaning-up temporary files ...
rm -rf .build_tmp
echo done.
echo
