// Created Sep 12, 2005 by Aidan Lane
// Based on au.edu.monash.csse.tonyj.cider.canvas.InterpretedTokenCanvas

package fsa_editor;

import au.edu.monash.csse.tonyj.cider.canvas.DrawableToken;
import au.edu.monash.csse.tonyj.cider.interpreter.Interpreter;
import au.edu.monash.csse.tonyj.cider.interpreter.GrammarSymbol;
import au.edu.monash.csse.tonyj.cider.interpreter.GrammarSymbolEvent;
import au.edu.monash.csse.tonyj.cider.interpreter.GrammarSymbolListener;
import java.util.*;
import java.util.logging.Level;


// TODO: rename me!
// WARNING!!! Don't extend JPanel - it will crash the JVM even on FindClass
public class CiderInterface implements GrammarSymbolListener {

    // Private variables
    private Interpreter	interpreter;

    // Note: "cider" is explicit, as Digest elements have their own IDs
    private static native void native_symbolAdded(int symbolId);// change me to ...drawableSymbolAdded
    private static native void native_symbolRemoved(int symbolId);
    private static native void native_symbolModified(int symbolId);

    CiderInterface( Interpreter inter ) {
	Interpreter.setLoggingLevel(Level.OFF); // helps real-time perf
	interpreter = inter;
	interpreter.addGrammarSymbolListener(this);
    }

    /**
     * This method is required by the GrammarSymbolListener interface.
     * It should not be called directly.
     *
     * Warning: This is only called when a symbol is not explicitly added using add().
     */
    public void symbolAdded(GrammarSymbolEvent gse)
    {
	GrammarSymbol s = gse.getGrammarSymbol();
	if (s instanceof DrawableToken) // Digest only cares about drawables
	    native_symbolAdded(s.getIDNumber());
    }

    /**
     * This method is required by the GrammarSymbolListener interface.
     * It should not be called directly.
     *
     * Warning: This is only called when a symbol is not explicitly removed using remove().
     */
    public void symbolRemoved(GrammarSymbolEvent gse)
    {
	GrammarSymbol s = gse.getGrammarSymbol();
	if (s instanceof DrawableToken) // Digest only cares about drawables
	    native_symbolRemoved(s.getIDNumber());
    }

    /**
     * This method is required by the GrammarSymbolListener interface.
     * It should not be called directly.
     */
    public void symbolModified(GrammarSymbolEvent gse)
    {
	GrammarSymbol s = gse.getGrammarSymbol();
	if (s instanceof DrawableToken) // Digest only cares about drawables
	    native_symbolModified(s.getIDNumber());
    }

    /**
     * @param symbol The symbol to be added. Must be a terminal symbol in the grammar.
     * @return <code>true</code> if successful, or <code>false</code> if the 
     * Interpreter would not accept the token as a valid terminal symbol.
     */
    public boolean add(GrammarSymbol symbol) {
	return interpreter.addTerminalSymbol(symbol);
    }

    /**
     * @param symbol The symbol to be removed. Must be a terminal symbol in the grammar.
     * @return <code>true</code> if successful, or <code>false</code> if the 
     * token could not be removed from the Interpreter.
     */
    public boolean remove(GrammarSymbol symbol) {
	return interpreter.removeTerminalSymbol(symbol);
    }

    public int getIDNumber(GrammarSymbol symbol) {
	return symbol.getIDNumber();
    }

    /**
     * Returns the Interpreter used by the canvas.
     */
    public Interpreter getInterpreter() {
	return interpreter;
    }

    /**
     * Convenience method.
     *
     * Prints the Interpreter's forest to System.out.
     */
    public void printForest() {
	interpreter.printForest(System.out);
    }
}