// Created on Sep 22, 2005 by Aidan Lane
// Because I can't use AWT headless on patforms such as the Mac...
// TODO: doc me properly!
// This has been designed to be a drop-in replacement for the BASICS of java.awt.Color
// and hence the methods that they have in common should express the same behaviour.
// To help ensure correct behaviour, the output of "javap -c fsa_editor/SimpleColor"
// was compared with the output of "javap -c java.awt.Color".

package fsa_editor;

public class SimpleColor {

    public static final SimpleColor white      = new SimpleColor(255, 255, 255);
    public static final SimpleColor WHITE      = white;
    public static final SimpleColor lightGray  = new SimpleColor(192, 192, 192);
    public static final SimpleColor LIGHT_GRAY = lightGray;
    public static final SimpleColor gray       = new SimpleColor(128, 128, 128);
    public static final SimpleColor GRAY       = gray;
    public static final SimpleColor darkGray   = new SimpleColor( 64,  64,  64);
    public static final SimpleColor DARK_GRAY  = darkGray;
    public static final SimpleColor black      = new SimpleColor(  0,   0,   0);
    public static final SimpleColor BLACK      = black;
    public static final SimpleColor red        = new SimpleColor(255,   0,   0);
    public static final SimpleColor RED        = red;
    public static final SimpleColor pink       = new SimpleColor(255, 175, 175);
    public static final SimpleColor PINK       = pink;
    public static final SimpleColor orange     = new SimpleColor(255, 200,   0);
    public static final SimpleColor ORANGE     = orange;
    public static final SimpleColor yellow     = new SimpleColor(255, 255,   0);
    public static final SimpleColor YELLOW     = yellow;
    public static final SimpleColor green      = new SimpleColor(  0, 255,   0);
    public static final SimpleColor GREEN      = green;
    public static final SimpleColor magenta    = new SimpleColor(255,   0, 255);
    public static final SimpleColor MAGENTA    = magenta;
    public static final SimpleColor cyan       = new SimpleColor(  0, 255, 255);
    public static final SimpleColor CYAN       = cyan;
    public static final SimpleColor blue       = new SimpleColor(  0,   0, 255);
    public static final SimpleColor BLUE       = blue;

    private int value; // amask=ff000000, rmask=ff0000 gmask=ff00 bmask=ff

    public SimpleColor(int r, int g, int b) {
	this(r, g, b, 255);
    }

    public SimpleColor(int r, int g, int b, int a) {
	value =
	    ((a & 0xFF) << 24) |
	    ((r & 0xFF) << 16) |
	    ((g & 0xFF) << 8)  |
	    b & 0xFF;
    }

    public SimpleColor(int rgb) {
	value = 0xff000000 | rgb;
    }

    public SimpleColor(int rgba, boolean hasalpha) {
        if (hasalpha)
            value = rgba;
        else
            value = 0xff000000 | rgba;
    }

    public int getRed() {
	return (getRGB() >> 16) & 0xFF; // use getRGB(), as it may be overloaded
    }

    public int getGreen() {
	return (getRGB() >> 8) & 0xFF;  // use getRGB(), as it may be overloaded
    }

    public int getBlue() {
	return getRGB() & 0xFF;         // use getRGB(), as it may be overloaded
    }

    public int getAlpha() {
	return (getRGB() >> 24) & 0xFF; // use getRGB(), as it may be overloaded
    }

    public int getRGB() {
	return value;
    }

    public int hashCode() {
	return value;
    }

    public boolean equals( Object obj ) {
	return
	    obj instanceof SimpleColor
	    && ((SimpleColor)obj).value == value;
    }
}