/*
 * Imported in to Digest by Aidan Lane on Tue Sep 13 2005.
 */

// A simple data structure for storing a collection of State objects

package fsa_editor;

import au.edu.monash.csse.tonyj.cider.interpreter.FinalState;
import au.edu.monash.csse.tonyj.cider.interpreter.State;
import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;

public class StateGroup {

	// Public variables
	public Set		stateSet;
	public State		dfaState;

	// Default Constructor
	public StateGroup()
	{
		stateSet = new HashSet();
		dfaState = null;
	}

	// Returns true iff a FinalState is present
	public boolean hasFinal()
	{
		if (stateSet == null)
			return false;

		Iterator iter = stateSet.iterator();
		while (iter.hasNext())
			if (iter.next() instanceof FinalState)
				return true;
		return false;
	}

	// Calculate the name of this state from its component states
	public String getName()
	{
		String name = "";

		Iterator iter = stateSet.iterator();
		while (iter.hasNext()) {
			State state = (State) iter.next();
			if (name.equals(""))
				name += state.get_label();
			else
				name += "," + state.get_label();
		}
		return name;
	}

	// Another object is equal if it is another state group with equal states
	public boolean equals(Object obj)
	{
		if (obj instanceof StateGroup) 
			return stateSet.equals(((StateGroup) obj).stateSet);
		else
			return false;
	}
}

