/*  -*- c++ -*-  (for Emacs)
 *
 *  digestcontrollerthreadhost.h
 *  Digest
 * 
 *  Created by Aidan Lane on Fri Sep 30 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIGESTCONTROLLERTHREADHOST_H
#define DIGESTCONTROLLERTHREADHOST_H


#include <QThread>

#include <QCoreApplication>

#include <jni.h>

#include "abstractmodel.h"


template <class T>
class DigestControllerThreadHost : public QThread {

public:
  DigestControllerThreadHost( JavaVM* jvm, QObject* parent = 0 )
    : QThread(parent),
      m_jvm(jvm),
      m_initialModel(0) {}

  DigestControllerThreadHost( AbstractModel* model,
			      JavaVM* jvm, QObject* parent = 0 )
    : QThread(parent),
      m_jvm(jvm),
      m_initialModel(model) {}

  virtual ~DigestControllerThreadHost() {
    quit();
    wait(); // TODO: make wait time-out a param
    // WARNING: we delete the controller at the end of run()
  }

  T* controller() const { return m_controller; }


protected:
  virtual void run()
  {
    /* Warning:
     * The controller is created in this new thread, hence it must NOT take the
     * host object (ControllerThreadHost) as its parent.
     */
    m_controller = new T( m_jvm );
    if ( m_initialModel != 0 )
      QCoreApplication::postEvent( m_controller,
				   new CChangeModelEvent(m_initialModel, this) );
    exec(); // begin event-loop
    delete m_controller;
    m_controller = 0;
  }


private:
  T*              m_controller;
  JavaVM*         m_jvm;
  AbstractModel*  m_initialModel;
};


#endif  // ! DIGESTCONTROLLERTHREADHOST_H
