/*  -*- c++ -*-  (for Emacs)
 *
 *  fsadiagramcontroller.h
 *  Digest
 * 
 *  Created by Aidan Lane on Fri Sep 30 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef FSADIAGRAMCONTROLLER_H
#define FSADIAGRAMCONTROLLER_H


#include <QHash>

#include "guidiagramcontroller.h"


class FsaDiagramController: public GuiDiagramController {

  Q_OBJECT

  friend void JNICALL Java_CiderInterface_native_symbolAdded( JNIEnv*, jclass, jint );
  friend void JNICALL Java_CiderInterface_native_symbolRemoved( JNIEnv*, jclass, jint );
  friend void JNICALL Java_FSACiderInterface_native_arrowPointsModified( JNIEnv*, jclass,
									 jint,
									 jdouble, jdouble,
									 jdouble, jdouble,
									 jdouble, jdouble );
  friend void JNICALL Java_FSACiderInterface_native_circleModified( JNIEnv*, jclass, jint,
								    jdouble, jdouble, jdouble );
  friend void JNICALL Java_FSACiderInterface_native_textRectModified( JNIEnv*, jclass, jint,
								      jdouble, jdouble,
								      jdouble, jdouble );


public:
  FsaDiagramController( JavaVM* jvm, QObject* parent = 0 );
  virtual ~FsaDiagramController();


protected:
  virtual void elementAddEvent( CElementAddEvent* );
  virtual void elementRemoveEvent( CElementRemoveEvent* );
  virtual void elementAttributeAddEvent( CElementAttributeAddEvent* );
  virtual void elementAttributeRemoveEvent( CElementAttributeRemoveEvent* );
  virtual void elementAttributeChangeDataEvent( CElementAttributeChangeDataEvent* );

  // Called by CiderInterface (in Java)
  void onSymbolAdded( jint symbolId );
  void onSymbolRemoved( jint symbolId );
  void setElementAttributeData( jint symbolId,
				int attributeType,
				const QVariant& newAttributeData );

  bool tryCiderElementAdd( AbstractElement* element );
  bool tryCiderElementRemove( AbstractElement* element );
  bool tryCiderElementModify( AbstractElement* element,
			      AbstractElementAttribute* attribute,
			      const QVariant& newAttributeData );

  jmethodID tryGetMethodID( jclass cls, const char* name, const char* sig );


private:
  void cleanup();

  JavaVM* m_jvm;

  // The following is tied to the thread - do not use them outside of it
  // TODO: move what doesn't need to be global back into run()
  // TODO: share MIDs!
  JNIEnv*    env;
  jclass     fsaCiderInterface_cls;
  jobject    fsaCiderInterface_gref;
  jmethodID  fsaCiderInterfaceConstructor_mid;
  jmethodID  add_mid;
  jmethodID  remove_mid;
  jmethodID  getIDNumber_mid;
  jmethodID  printForest_mid;
  jmethodID  createDrawableArrow_mid;
  jmethodID  createDrawableCircle_mid;
  jmethodID  createDrawableText_mid;
  jmethodID  setArrowPoints_mid;
  jmethodID  setCirclePos_mid;
  jmethodID  setCircleRadius_mid;
  jmethodID  setTextPos_mid;
  jmethodID  setTextHalfDimensions_mid;

  // Note: m_symbolIdToElementPtr uses the symbol ID as a key, not a ref, as each
  //       ref has a different jobject pointer - preventing their use in QHash.
  QHash<int, AbstractElement*>     m_symbolIdToElementPtr;
  QHash<AbstractElement*, jobject> m_elementPtrToSymbol;
};


#endif // ! FSADIAGRAMCONTROLLER_H
