/*  -*- c++ -*-  (for Emacs)
 *
 *  guidiagramcontroller.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 9 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "guidiagramcontroller.h"

#include <QApplication>
#include <QMessageBox>

#include "digest.h"


/*!
 * Constructs a diagram controller that contains GUI specific code.
 */
GuiDiagramController::GuiDiagramController( JavaVM*, QObject* parent )
  : DiagramController(parent)
{}


/*!
 * Constructs a diagram controller that contains GUI specific code.
 */
GuiDiagramController::GuiDiagramController( AbstractModel* doc, JavaVM*, QObject* parent )
  : DiagramController(doc, parent)
{}


/*!
 * Re-implemented to add graphical error reporting with QMessageBox.
 */
bool GuiDiagramController::saveDocToFile( const QString& filename ) const
{
  if( ! DiagramController::saveDocToFile(filename) )
    {
      // TODO: make the message useful!
      QMessageBox::critical( 0, Digest::appName,
			     tr("Couldn't Save"),
			     QMessageBox::Ok, QMessageBox::NoButton );
      return false;
    }
  return true;
}


/*!
 * Re-implemented to add graphical error reporting with QMessageBox.
 */
bool GuiDiagramController::initDocFromFile( const QString& filename )
{
  if( ! DiagramController::initDocFromFile(filename) )
    {
      // TODO: make the message useful!
      QMessageBox::critical( 0, Digest::appName,
			     tr("Couldn't Open"),
			     QMessageBox::Ok, QMessageBox::NoButton );
      return false;
    }
  return true;
}
