/*  -*- c++ -*-  (for Emacs)
 *
 *  guidiagramcontroller.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 9 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIDIAGRAMCONTROLLER_H
#define GUIDIAGRAMCONTROLLER_H


#include "MvcDiagram/diagramcontroller.h"


#include <jni.h>


/*!
 * \b Warning:
 * This controller was designed to be placed in its own thread, such as by using
 * ControllerThreadHost<GuiDiagramController>.
 * This is because another Java environment will be created in it and the current
 * thread will be attached to the JVM.
 * This allows the lengthy processing of some controller events (especially when
 * CIDER is used) to run without freezing the GUI.
 * Having the controller run in another thread is natural anyway, as events are
 * posted to it (but NOT waited for) and then the controller posts events to the
 * model and the views if and when it chooses to do so.
 */
// TODO: rename me to DigestDiagramController !
class GuiDiagramController: public DiagramController {

  Q_OBJECT

public:
  GuiDiagramController( JavaVM* jvm, QObject* parent = 0 );
  GuiDiagramController( AbstractModel* diagram, JavaVM* jvm, QObject* parent = 0 );


protected:
  virtual bool saveDocToFile( const QString& filename ) const;
  virtual bool initDocFromFile( const QString& filename );
};


#endif // ! GUIDIAGRAMCONTROLLER_H
