// BASED ON: qdesigner_actions.cpp in qt-mac-opensource-4.0.0-b2-snapshot-20050318, located in the /tools/designer/src/designer/ sub-dir of Qt.
//           Imported on Wed Mar 30 2005 by Aidan Lane.
//           Modifications Copyright (c) CEMA, Monash University. All rights reserved.
/****************************************************************************
 **
 ** Copyright (C) 1992-2005 Trolltech AS. All rights reserved.
 **
 ** This file is part of the designer application of the Qt Toolkit.
 **
 ** This file may be distributed and/or modified under the terms of the
 ** GNU General Public License version 2 as published by the Free Software
 ** Foundation and appearing in the file LICENSE.GPL included in the
 ** packaging of this file.
 **
 ** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
 **   information about Qt Commercial License Agreements.
 ** See http://www.trolltech.com/gpl/ for GPL licensing information.
 **
 ** Contact info@trolltech.com if any conditions of this licensing are
 ** not clear to you.
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/

#include "digestactionmanager.h"

// TODO: remove what isn't needed:
#include <QAction>
#include <QActionGroup>
#include <QCloseEvent>
#include <QFileDialog>
#include <QMessageBox>
#include <QIcon>

#include "digestapplication.h"
#include "mdidiagramwindow.h"
#include "guidiagramcontroller.h"

/* 
 * The following strings are used more than once, so macros have been used to
 * ensure  consistency and assist when modifications are required.
 */
#define SHOW_STR                tr("Show ")
#define HIDE_STR                tr("Hide ")
#define TURN_STR                tr("Turn ")
#define ON_STR                  tr(" On")
#define OFF_STR                 tr(" Off")
#define GRID_STR                tr("&Grid")
#define SNAP_TO_GRID_STR        tr("Snap-to-Grid")     
#define ELEMENT_INSPECTOR_STR   tr("&Inspector") // "friendlier" name than "Element Inspector"
#define INDENT_MENU_ITEM_STR    tr("   ")

// TODO: check which symbol is best for which platform (other than Mac OS X)
#ifdef Q_WS_MAC // _IS_ Mac
#define ELLIPSIS_STR  QChar(0x2026)  // the single "..." character - used on Mac OS X
#else
#define ELLIPSIS_STR  "..."
#endif


static DigestActionManager* mdiActionManagerInstance = 0;


DigestActionManager::DigestActionManager( DigestApplication* diagramManager )
  : QObject(diagramManager),
    m_diagramManager(diagramManager)
{
  QAction* sep = 0;
  QAction* textSep = 0;

  // TODO: implement a proper singleton interface!
  Q_ASSERT( mdiActionManagerInstance == 0
	    && "There may only be one instance of DigestActionManager" );
  mdiActionManagerInstance = this;


  Q_ASSERT( ! m_diagramManager.isNull() );

  // called rarely -> dynamic cast slowness ok
  m_activeDiagramWindow = dynamic_cast<MDIDiagramWindow*>( m_diagramManager->activeChildWindow() ); // FIXME

  connect( m_diagramManager,
	   SIGNAL(activeChildChanged(MDIChildBase*)),
	   SLOT(setActiveDiagramWindow(MDIChildBase*)) );

  //    QDesignerSettings settings;
  m_fileActions = new QActionGroup(this);
  m_fileActions->setExclusive(false);

  m_recentFilesActions = new QActionGroup(this);
  m_recentFilesActions->setExclusive(false);

  m_editActions = new QActionGroup(this);
  m_editActions->setExclusive(false);

  m_viewActions = new QActionGroup(this);
  m_viewActions->setExclusive(false);

  m_toolActions = new QActionGroup(this);
  m_toolActions->setExclusive(true);      // _IS_ exclusive

  m_windowActions = new QActionGroup(this);
  m_windowActions->setExclusive(false);

  m_helpActions = new QActionGroup(this);
  m_helpActions->setExclusive(false);


  //
  // File actions
  //
  m_newDiagramAction = new QAction( tr("&New"), m_fileActions );
  m_newDiagramAction->setShortcut( tr("CTRL+N") );
  connect( m_newDiagramAction, SIGNAL(triggered()), m_diagramManager, SLOT(newDiagram()) );

  m_openDiagramAction = new QAction( tr("&Open") + ELLIPSIS_STR, m_fileActions );
  m_openDiagramAction->setShortcut( tr("CTRL+O") );
  connect( m_openDiagramAction, SIGNAL(triggered()), m_diagramManager, SLOT(openDiagram()) );

  QAction* act = 0;
  // Need to insert this into the QAction.
  for (int i = 0; i < MaxRecentFiles; ++i) {
    act = new QAction(this);
    act->setVisible(false);
    connect(act, SIGNAL(triggered()), this, SLOT(openRecentForm()));
    m_recentFilesActions->addAction(act);
  }
  updateRecentFileActions();


  act = new QAction(tr("Clear &Menu"), this);
  connect(act, SIGNAL(triggered()), this, SLOT(clearRecentFiles()));
  m_recentFilesActions->addAction(act);

  sep = new QAction(this);
  sep->setSeparator(true);
  m_fileActions->addAction(sep);

  // Warning! Don't add this action to m_fileActions yet. We add it further down if not on Mac OS X.
  // Note: this is not called "closeDiagram", as it can close the about and prefs boxes too.
  m_closeWindowAction = new QAction( tr("&Close"), this );
  m_closeWindowAction->setShortcut(tr("CTRL+W"));
  connect(m_closeWindowAction, SIGNAL(triggered()), m_diagramManager, SLOT(closeActiveWindow()));
#ifdef Q_WS_MAC // _IS_ Mac
  m_fileActions->addAction( m_closeWindowAction ); // *** on Mac OS X, place the Close action here
#endif

  m_saveDiagramAction = new QAction( tr("&Save"), m_fileActions );
  m_saveDiagramAction->setShortcut( tr("CTRL+S") );
  connect(m_saveDiagramAction, SIGNAL(triggered()), m_diagramManager, SLOT(saveDiagram()));

  m_saveDiagramAsAction = new QAction( tr("Save &As") + ELLIPSIS_STR, m_fileActions );  
  m_saveDiagramAsAction->setShortcut( tr("SHIFT+CTRL+S") );
  connect( m_saveDiagramAsAction, SIGNAL(triggered()), m_diagramManager, SLOT(saveDiagramAs()) );

  m_saveAllDiagramsAction = new QAction( tr("Save All"), m_fileActions );  
  connect( m_saveAllDiagramsAction, SIGNAL(triggered()), m_diagramManager, SLOT(saveAllDiagrams()) );

#ifndef Q_WS_MAC // _NOT_ Mac
  sep = new QAction( m_fileActions ); // separate the Close action from the save actions on these systems
  sep->setSeparator( true );
  m_fileActions->addAction( m_closeWindowAction ); // *** on systems OTHER THAN Mac OS X, place the Close
 action here
#endif

  // On Mac OS X, the quit item is moved to the appliction menu, so this separator is redundant.
#ifndef Q_WS_MAC // _NOT_ Mac
  sep = new QAction( m_fileActions );
  sep->setSeparator( true );
#endif

  // We use the string "Exit", as that is what is known as on Windows and Linux.
  // On Mac OS X, Qt will remove this anyway and add "Quit Nodal" to the application menu.
  m_appQuitAction = new QAction( tr("E&xit"), m_fileActions );
  connect( m_appQuitAction, SIGNAL(triggered()), m_diagramManager, SLOT(appQuit()) );

  //
  // Edit actions
  //
  m_undoAction = new QAction( tr("&Undo"), m_editActions );
  m_undoAction->setShortcut( tr("CTRL+Z") );
  m_undoAction->setEnabled( false );

  m_redoAction = new QAction( tr("&Redo"), m_editActions );
  m_redoAction->setShortcut( tr("CTRL+SHIFT+Z") );
  m_redoAction->setEnabled( false );

  sep = new QAction( m_editActions );
  sep->setSeparator( true );

  m_cutAction = new QAction( tr("Cu&t"), m_editActions );
  m_cutAction->setEnabled( false );

  m_copyAction = new QAction( tr("&Copy"), m_editActions );
  m_copyAction->setEnabled( false );

  m_pasteAction = new QAction( tr("&Paste"), m_editActions );
  m_pasteAction->setEnabled( false );

  m_deleteAction = new QAction( tr("&Delete"), m_editActions );
  m_deleteAction->setEnabled( false );

  m_selectAllAction = new QAction(tr("Select &All"), m_editActions );

  sep = new QAction( m_editActions );
  sep->setSeparator( true );

  m_bringToFrontAction = new QAction( tr("Bring To Front"), m_editActions );
  m_bringToFrontAction->setShortcut( tr("CTRL+SHIFT+]") );
  m_bringToFrontAction->setEnabled( false );

  m_bringForwardAction = new QAction( tr("Bring Forward"), m_editActions );
  m_bringForwardAction->setShortcut( tr("CTRL+]") );
  m_bringForwardAction->setEnabled( false );

  m_sendBackwardAction = new QAction( tr("Send Backward"), m_editActions );
  m_sendBackwardAction->setShortcut( tr("CTRL+[") );
  m_sendBackwardAction->setEnabled( false );

  m_sendToBackAction = new QAction( tr("Send To Back"), m_editActions );
  m_sendToBackAction->setShortcut( tr("CTRL+SHIFT+[") );
  m_sendToBackAction->setEnabled( false );

  sep = new QAction( m_editActions );
  sep->setSeparator( true );

  m_showPropertiesAction = new QAction( tr("&Diagram Properties") + ELLIPSIS_STR, m_editActions );
  connect( m_showPropertiesAction, SIGNAL(triggered()), SLOT(showProperties()) );

  // Qt will automatically move this to the applications menu as "Preferences...".
  m_appPrefsAction = new QAction( tr("&Preferences") + ELLIPSIS_STR , m_editActions );
  connect( m_appPrefsAction, SIGNAL(triggered()), m_diagramManager, SLOT(showAppPrefs()) );

  //
  // edit mode actions
  //
  /* TODO: remove the following:
    m_editWidgetsAction = new QAction(tr("Edit Widgets"), this);
    m_editWidgetsAction->setCheckable(true);
    m_editWidgetsAction->setShortcut(tr("F2"));
    m_editWidgetsAction->setIcon(QIcon(m_core->resourceLocation() + QLatin1String("/widgettool.png")));
    connect(formWindowManager, SIGNAL(activeDiagramWindowChanged(MDIDiagramWindow*)),
    this, SLOT(activeDiagramWindowChanged(MDIDiagramWindow *)));
    connect(m_editWidgetsAction, SIGNAL(triggered()), this, SLOT(editWidgetsSlot()));
    m_toolActions->addAction(m_editWidgetsAction);
    m_editWidgetsAction->setChecked(true);
    m_editWidgetsAction->setEnabled(false);
    QList<QObject*> builtinPlugins = QPluginLoader::staticInstances();
    foreach (QObject *plugin, builtinPlugins) {
    if (MDIDiagramWindowPlugin *formEditorPlugin = qobject_cast<MDIDiagramWindowPlugin*>(plugin)) {
    m_toolActions->addAction(formEditorPlugin->action());
    formEditorPlugin->action()->setCheckable(true);
    }
    }
    m_toolActions->addAction(formWindowManager->actionShowResourceEditor());

    m_uiMode = new QActionGroup(this);
    m_uiMode->setExclusive(true);
    m_sdiAction = m_uiMode->addAction(tr("Multiple Top-Level Windows"));
    m_sdiAction->setCheckable(true);
    m_mdiAction = m_uiMode->addAction(tr("All-in-One Window"));
    m_mdiAction->setCheckable(true);
    if (settings.uiMode() == DigestApplication::WorkspaceMode)
    m_mdiAction->setChecked(true);
    else
    m_sdiAction->setChecked(true);
    connect(m_uiMode, SIGNAL(triggered(QAction *)), this, SLOT(updateUIMode(QAction *)));
  */

  //
  // tool actions
  //
  // TODO: remove the following
  //   m_useBigIcons = new QAction(tr("Use &Big Toolbar Icons"), this);
  //   m_useBigIcons->setCheckable(true);
  //    m_useBigIcons->setChecked(settings.useBigIcons());


  //
  // View actions
  //
  m_showLabelsAction = new QAction( SHOW_STR + tr("&Labels"), m_viewActions );

  sep = new QAction( m_viewActions );
  sep->setSeparator( true );

  m_actualSizeAction = new QAction( tr("Actual Size"), m_viewActions );
  m_actualSizeAction->setShortcut( Qt::CTRL + Qt::Key_0 );

  m_zoomInAction = new QAction( tr("Zoom &In"), m_viewActions );
  m_zoomInAction->setShortcut( Qt::CTRL + Qt::Key_Plus );

  m_zoomOutAction = new QAction( tr("Zoom &Out"), m_viewActions );
  m_zoomOutAction->setShortcut( Qt::CTRL + Qt::Key_Minus );

  sep = new QAction( m_viewActions );
  sep->setSeparator( true );

  m_toggleGridShownAction = new QAction( SHOW_STR + GRID_STR, m_viewActions );
  syncToggleGridShownActionText();
  m_toggleGridShownAction->setShortcut( Qt::ALT + Qt::CTRL + Qt::Key_G );
  connect( m_toggleGridShownAction, SIGNAL(triggered()), SLOT(toggleGridShown()) );

  m_toggleSnapToGridAction = new QAction( TURN_STR + SNAP_TO_GRID_STR + ON_STR, m_viewActions );
  syncToggleSnapToGridActionText();
  m_toggleSnapToGridAction->setShortcut( Qt::CTRL + Qt::Key_G );
  connect( m_toggleSnapToGridAction, SIGNAL(triggered()), SLOT(toggleSnapToGrid()) );

  sep = new QAction( m_viewActions );
  sep->setSeparator( true );

  m_fullScreenAction = new QAction( tr("&Full Screen"), m_viewActions );


  //
  // Tool actions
  //
  unsigned toolShortcutNum = 0;
  connect( m_toolActions, SIGNAL(triggered(QAction*)), SLOT(setCurrentTool(QAction*)) ); // NOTE: THIS IS THE ONE AND ONLY CONNECTION FOR THE ENTIRE TOOL ACTION GROUP!!!

  textSep = new QAction( tr("General"), m_toolActions );
  textSep->setEnabled( false );

  m_selectionToolAction = new QAction( QIcon(":/images/tools/SelectionTool.png"), // i.e. "Pointer"
				       INDENT_MENU_ITEM_STR + tr("Selection"), m_toolActions );
  m_selectionToolAction->setShortcut( Qt::CTRL + Qt::Key_1 + toolShortcutNum++);
  m_selectionToolAction->setCheckable( true );
  m_selectionToolAction->setChecked( true ); // make this one CHECKED by default

  m_zoomToolAction = new QAction( QIcon(":/images/tools/ZoomTool.png"),
				  INDENT_MENU_ITEM_STR + tr("Zoom"), m_toolActions );
  m_zoomToolAction->setShortcut( Qt::CTRL + Qt::Key_1 + toolShortcutNum++ );
  m_zoomToolAction->setCheckable( true );

  textSep = new QAction( tr("Creational"), m_toolActions );
  textSep->setEnabled( false );

  m_shapeToolAction = new QAction( QIcon(":/images/tools/ShapeTool.png"),
				   INDENT_MENU_ITEM_STR + tr("Shape"), m_toolActions );
  m_shapeToolAction->setShortcut( Qt::CTRL + Qt::Key_1 + toolShortcutNum++ );
  m_shapeToolAction->setCheckable( true );

  m_polygonToolAction = new QAction( QIcon(":/images/tools/PolygonTool.png"),
				     INDENT_MENU_ITEM_STR + tr("Polygon"), m_toolActions );
  m_polygonToolAction->setShortcut( Qt::CTRL + Qt::Key_1 + toolShortcutNum++ );
  m_polygonToolAction->setCheckable( true );

  // Note: "Line" seems a little more "user friendly" than "Polyline".
  //       This convention also appears in other diagramming software.
  m_polylineToolAction = new QAction( QIcon(":/images/tools/PolylineTool.png"),
				      INDENT_MENU_ITEM_STR + tr("Line"), m_toolActions );
  m_polylineToolAction->setShortcut( Qt::CTRL + Qt::Key_1 + toolShortcutNum++ );
  m_polylineToolAction->setCheckable( true );

  m_textToolAction = new QAction( QIcon(":/images/tools/TextTool.png"),
				  INDENT_MENU_ITEM_STR + tr("Text"), m_toolActions );
  m_textToolAction->setShortcut( Qt::CTRL + Qt::Key_1 + toolShortcutNum++ );
  m_textToolAction->setCheckable( true );

  //
  // Window actions
  //
  m_minimizeWindowAction = new QAction(tr("&Minimize"), this);
  m_minimizeWindowAction->setShortcut(tr("CTRL+M"));
  m_windowActions->addAction(m_minimizeWindowAction);
  connect(m_minimizeWindowAction, SIGNAL(triggered()), this, SLOT(minimizeWindow()));

  m_zoomWindowAction = new QAction(tr("&Zoom"), this);
  m_windowActions->addAction(m_zoomWindowAction);
  connect(m_zoomWindowAction, SIGNAL(triggered()), this, SLOT(zoomWindow()));

  sep = new QAction( m_windowActions );
  sep->setSeparator( true );

  m_toggleElementInspectorAction = new QAction( SHOW_STR + ELEMENT_INSPECTOR_STR, m_windowActions );
  m_toggleElementInspectorAction->setShortcut( Qt::SHIFT + Qt::CTRL + Qt::Key_I ); // <I>nfo / <I>nspector -> should be <I> (not <E>)
  syncElementInspectorActionText(); 
  connect( m_toggleElementInspectorAction, SIGNAL(triggered()), SLOT(toggleElementInspector()) );
  connect( m_diagramManager,
	   SIGNAL(elementInspectorVisibilityToggled()),
	   SLOT(syncElementInspectorActionText()) );

  sep = new QAction( m_windowActions );
  sep->setSeparator( true );

  m_bringAllToFrontAction = new QAction(tr("Bring All to Front"), this);
  connect(m_bringAllToFrontAction, SIGNAL(triggered()), this, SLOT(bringAllToFront()));
  m_windowActions->addAction(m_bringAllToFrontAction);

  //
  // Help actions
  //
  m_appHelpAction = new QAction( tr("Nodal &Help"), m_helpActions );// FIXME: use global name, vs. Nodal !
  connect(m_appHelpAction, SIGNAL(triggered()), m_diagramManager, SLOT(showAppHelp()));
#ifdef Q_WS_MAC
  m_appHelpAction->setShortcut(Qt::CTRL + Qt::Key_Question);
#else
  m_appHelpAction->setShortcut(Qt::Key_F1);
#endif

  // On Mac OS X, the about items are merged in so this separator is redundant.
#ifndef Q_WS_MAC
  sep = new QAction( m_helpActions );
  sep->setSeparator( true );
#endif
  m_appAboutAction = new QAction( tr("&About Nodal"), m_helpActions ); // FIXME: use global name, v.s. Nodal !
  connect(m_appAboutAction, SIGNAL(triggered()), m_diagramManager, SLOT(showAppAbout()));

  //
  // connections
  //
  fixActionContext();
  setActiveDiagramWindow( m_diagramManager->activeChildWindow() );
}


DigestActionManager::~DigestActionManager()
{
  Q_ASSERT( mdiActionManagerInstance != 0 ); // safety check
  mdiActionManagerInstance = 0;
}

DigestActionManager* DigestActionManager::instance() {
  return mdiActionManagerInstance;
}


DigestApplication *DigestActionManager::diagramManager() const
{ return m_diagramManager; }

MDIDiagramWindow *DigestActionManager::activeDiagramWindow() const
{ return m_activeDiagramWindow; }

QActionGroup *DigestActionManager::fileActions() const
{ return m_fileActions; }

QActionGroup *DigestActionManager::editActions() const
{ return m_editActions; }

QActionGroup *DigestActionManager::viewActions() const
{ return m_viewActions; }

QActionGroup *DigestActionManager::windowActions() const
{ return m_windowActions; }

QActionGroup *DigestActionManager::helpActions() const
{ return m_helpActions; }

QAction *DigestActionManager::newDiagramAction() const
{ return m_newDiagramAction; }

QAction *DigestActionManager::openDiagramAction() const
{ return m_openDiagramAction; }

QAction *DigestActionManager::closeWindowAction() const
{ return m_closeWindowAction; }

QAction *DigestActionManager::saveDiagramAction() const
{ return m_saveDiagramAction; }

QAction *DigestActionManager::saveDiagramAsAction() const
{ return m_saveDiagramAsAction; }

QAction *DigestActionManager::saveAllDiagramsAction() const
{ return m_saveAllDiagramsAction; }

QAction *DigestActionManager::appQuitAction() const
{ return m_appQuitAction; }

QAction *DigestActionManager::undoAction() const
{ return m_undoAction; }

QAction *DigestActionManager::redoAction() const
{ return m_redoAction; }

QAction *DigestActionManager::cutAction() const
{ return m_cutAction; }

QAction *DigestActionManager::copyAction() const
{ return m_copyAction; }

QAction *DigestActionManager::pasteAction() const
{ return m_pasteAction; }

QAction *DigestActionManager::selectAllAction() const
{ return m_selectAllAction; }

QAction *DigestActionManager::deleteAction() const
{ return m_deleteAction; }

QAction *DigestActionManager::appPrefsAction() const
{ return m_appPrefsAction; }

QAction* DigestActionManager::minimizeWindowAction() const
{ return m_minimizeWindowAction; }

QAction* DigestActionManager::zoomWindowAction() const
{ return m_zoomWindowAction; }

QAction* DigestActionManager::toggleElementInspectorAction() const
{ return m_toggleElementInspectorAction; }

QAction *DigestActionManager::bringAllToFront() const
{ return m_bringAllToFrontAction; }

QAction *DigestActionManager::appHelpAction() const
{ return m_appHelpAction; }

QAction *DigestActionManager::appAboutAction() const
{ return m_appAboutAction; }


/*TODO: re-use me for the tool palette mode
  void DigestActionManager::editWidgetsSlot()
  {
  
  MDIDiagramWindowManager *formWindowManager = core()->formWindowManager();
  for (int i=0; i<formWindowManager->formWindowCount(); ++i) {
  MDIDiagramWindow *formWindow = formWindowManager->formWindow(i);
  formWindow->editWidgets();
  }
  
  }
*/

void DigestActionManager::setActiveDiagramWindow( MDIChildBase* child )
{
  Q_ASSERT( m_diagramManager != 0 );

  // We shouldn't be called too much -> dynamic_cast slowness shouldn't matter
  MDIDiagramWindow* diagramWindow = dynamic_cast<MDIDiagramWindow*>( child );

  // Clean-up connections from the previously current window (if there is one)
  if ( ! m_activeDiagramWindow.isNull() )
    {
      // Remove all connections from it to us - see the end of this method for
      // what we connect to it.
      GuiDiagramController* c
	= m_diagramManager->managedDiagrams().value(m_activeDiagramWindow).cached_controller;
      if ( c != 0 ) c->disconnect( this );
    }

  m_activeDiagramWindow = diagramWindow;
  bool activeExists = ! m_activeDiagramWindow.isNull();

  // Look after select FILE actions
  //m_closeWindowAction->setEnabled( activeExists ); // TODO: make this dependant on there being ANY window open - including gesture & sql browsers, about and pref boxes, etc... i.e. ANY window!
  m_saveDiagramAction->setEnabled( activeExists );
  m_saveDiagramAsAction->setEnabled( activeExists );

  // "Save All" only enabled if there are 1+ diagram windows in existane, be one
  // active or not.
  m_saveAllDiagramsAction->setEnabled( m_diagramManager->childWindows().size() > 0 );

  /*
   * None of the EDIT or VIEW actions could be used without an active window.
   *
   * EXCEPTION: For Linux and Window compatibility, m_appPrefsAction lives in
   * m_editActions, so we CAN'T just enable or disable the entire group!
   */
  foreach ( QAction* a, m_editActions->actions() )
    a->setEnabled( activeExists );
  m_appPrefsAction->setEnabled( true ); // unconditionally enabled
  m_viewActions->setEnabled( activeExists );

  // Look after select WINDOW actions
  m_minimizeWindowAction->setEnabled( activeExists );
  m_zoomWindowAction->setEnabled( activeExists );
  m_bringAllToFrontAction->setEnabled( activeExists );


  // If it is enabled, then update the text for several actions that are
  // dependant on the active diagram window.
  if ( activeExists
       && m_diagramManager->managedDiagrams().contains(diagramWindow) )
    {
      syncToggleGridShownActionText();
      syncToggleSnapToGridActionText();

      GuiDiagramController* c
	= m_diagramManager->managedDiagrams().value(diagramWindow).cached_controller;
      if ( c != 0 )
	{
	  connect( m_undoAction, SIGNAL(triggered()),
		   c, SLOT(undo()) );
	  connect( m_redoAction, SIGNAL(triggered()),
		   c, SLOT(redo()) );
	  connect( m_bringToFrontAction, SIGNAL(triggered()),
		   c, SLOT(elementSelectionBringToFront()) );
	  connect( m_sendToBackAction, SIGNAL(triggered()),
		   c, SLOT(elementSelectionSendToBack()) );
	  connect( m_bringForwardAction, SIGNAL(triggered()),
		   c, SLOT(elementSelectionBringForward()) );
	  connect( m_sendBackwardAction, SIGNAL(triggered()),
		   c, SLOT(elementSelectionSendBackward()) );
	}
    }
}


void DigestActionManager::fixActionContext()
{
  QList<QAction*> actions;
  actions += m_fileActions->actions();
  actions += m_editActions->actions();
  actions += m_viewActions->actions();
  actions += m_toolActions->actions();
  actions += m_windowActions->actions();
  actions += m_helpActions->actions();

  foreach ( QAction* a, actions ) {
    a->setShortcutContext(Qt::ApplicationShortcut);
  }
}


/* TODO: remove me if UNWANTED
bool DigestActionManager::readInForm(const QString &fileName)
{
  // First make sure that we don't have this one open already.
  MDIDiagramWindowManager *formWindowManager = core()->formWindowManager();
  int totalWindows = formWindowManager->formWindowCount();
  for (int i = 0; i < totalWindows; ++i) {
  MDIDiagramWindow *w = formWindowManager->formWindow(i);
  if (w->fileName() == fileName) {
  w->raise();
  formWindowManager->setActiveFormWindow(w);
  addRecentFile(fileName);
  return true;
  }
  }

  // Otherwise load it.
  QFile f(fileName);
  if (!f.open(QFile::ReadOnly)) {
  QMessageBox::warning(m_diagramManager->topLevel(), tr("Read Error"), tr("Couldn't open file: %1\nReason: %2")
  .arg(f.fileName()).arg(f.errorString()));
  return false;
  }


  QDesignerFormWindow *formWindow = workbench()->createFormWindow();
  if (MDIDiagramWindow *editor = formWindow->editor()) {
  editor->setFileName(fileName);
  editor->setContents(&f);
  Q_ASSERT(editor->mainContainer() != 0);
  formWindow->resize(editor->mainContainer()->size());
  formWindowManager->setActiveFormWindow(editor);
  }
  formWindow->show();
  addRecentFile(fileName);
  return true;
}

bool DigestActionManager::writeOutForm(MDIDiagramWindow *fw, const QString &saveFile)
{
    Q_ASSERT(fw && !saveFile.isEmpty());
    QFile f(saveFile);
    while (!f.open(QFile::WriteOnly)) {
    QMessageBox box(tr("Save Form?"),
    tr("Could not open file: %1"
    "\nReason: %2"
    "\nWould you like to retry or change your file?")
    .arg(f.fileName()).arg(f.errorString()),
    QMessageBox::Warning,
    QMessageBox::Yes | QMessageBox::Default, QMessageBox::No,
    QMessageBox::Cancel | QMessageBox::Escape, fw, Qt::Sheet);
    box.setButtonText(QMessageBox::Yes, tr("Retry"));
    box.setButtonText(QMessageBox::No, tr("Select New File"));
    switch(box.exec()) {
    case QMessageBox::Yes:
    break;
    case QMessageBox::No: {
    QString fileName = QFileDialog::getSaveFileName(fw, tr("Save form as"),
    QDir::current().absolutePath(), QString("*.ui"));
    if (fileName.isEmpty())
    return false;
    f.setFileName(fileName);
    fw->setFileName(fileName);
    break; }
    case QMessageBox::Cancel:
    return false;
    }
    }
    QByteArray utf8Array = fw->contents().toAscii();
    while (f.write(utf8Array, utf8Array.size()) != utf8Array.size()) {
    QMessageBox box(tr("Save Form?"),
    tr("Could not write file: %1\nReason:%2\nWould you like to retry?")
    .arg(f.fileName()).arg(f.errorString()),
    QMessageBox::Warning,
    QMessageBox::Yes | QMessageBox::Default, QMessageBox::No, 0,
    fw, Qt::Sheet);
    box.setButtonText(QMessageBox::Yes, tr("Retry"));
    box.setButtonText(QMessageBox::No, tr("Don't Retry"));
    switch(box.exec()) {
    case QMessageBox::Yes:
    f.resize(0);
    break;
    case QMessageBox::No:
    return false;
    }
    }
    addRecentFile(saveFile);
    fw->setDirty(false);
    fw->window()->setWindowModified(false);
    return true;
}
*/

void DigestActionManager::updateRecentFileActions()
{
  /*TODO: re-enable me:
    QDesignerSettings settings;
    QStringList files = settings.recentFilesList();
    int originalSize = files.size();
    int numRecentFiles = qMin(files.size(), int(MaxRecentFiles));
    QList<QAction *> recentFilesActs = m_recentFilesActions->actions();

    for (int i = 0; i < numRecentFiles; ++i) {
    QFileInfo fi(files[i]);
    // If the file doesn't exist anymore, just remove it from the list so
    // people don't get confused.
    if (!fi.exists()) {
    files.removeAt(i);
    --i;
    numRecentFiles = qMin(files.size(), int(MaxRecentFiles));
    continue;
    }
    QString text = fi.fileName();
    recentFilesActs[i]->setText(text);
    recentFilesActs[i]->setIconText(files[i]);
    recentFilesActs[i]->setVisible(true);
    }

    for (int j = numRecentFiles; j < MaxRecentFiles; ++j)
    recentFilesActs[j]->setVisible(false);

    // If there's been a change, right it back
    if (originalSize != files.size())
    settings.setRecentFilesList(files);
  */
}


void DigestActionManager::openRecentForm()
{
  /*
    if (QAction *action = qobject_cast<QAction *>(sender())) {
    if (!readInForm(action->iconText()))
    updateRecentFileActions(); // File doesn't exist, remove it from settings
    }
  */
}

void DigestActionManager::clearRecentFiles()
{
  /*
    QDesignerSettings settings;
    settings.setRecentFilesList(QStringList());
    updateRecentFileActions();
  */
}

QActionGroup *DigestActionManager::recentFilesActions() const
{
  return m_recentFilesActions;
}

void DigestActionManager::addRecentFile(const QString& ) // TODO: add me back: fileName)
{
  /*
    QDesignerSettings settings;
    QStringList files = settings.recentFilesList();
    files.removeAll(fileName);
    files.prepend(fileName);
    while (files.size() > MaxRecentFiles)
    files.removeLast();

    settings.setRecentFilesList(files);
    updateRecentFileActions();
  */
}

void DigestActionManager::toggleGridShown()
{
  Q_ASSERT( ! m_activeDiagramWindow.isNull() );
  m_activeDiagramWindow->setGridShown( ! m_activeDiagramWindow->gridShown() );
  syncToggleGridShownActionText();
}

void DigestActionManager::toggleSnapToGrid()
{
  Q_ASSERT( ! m_activeDiagramWindow.isNull() );
  m_activeDiagramWindow->setSnapToGridOn( ! m_activeDiagramWindow->hasSnapToGridOn() );
  syncToggleSnapToGridActionText();
}

void DigestActionManager::increaseGridRes()
{
}

void DigestActionManager::decreaseGridRes()
{
}


void DigestActionManager::showProperties()
{
  Q_ASSERT( ! m_activeDiagramWindow.isNull() );
  m_activeDiagramWindow->showProperties();
}


// TODO: doc me!
// If the action is unknown, then it will default to the selection tool
void DigestActionManager::setCurrentTool( QAction* toolAction )
{
  Digest::Tool t = Digest::SelectionTool;

  if      ( toolAction == m_selectionToolAction )
    t = Digest::SelectionTool;
  else if ( toolAction == m_zoomToolAction )
    t = Digest::ZoomTool;
  else if ( toolAction == m_shapeToolAction )
    t = Digest::ShapeTool;
  else if ( toolAction == m_polygonToolAction )
    t = Digest::PolygonTool;
  else if ( toolAction == m_polylineToolAction )
    t = Digest::PolylineTool;
  else if ( toolAction == m_textToolAction )
    t = Digest::TextTool;
  else
    qDebug("DigestActionManager::setCurrentTool : Unknown Tool -> Will default to selection tool."); // TODO: remove me?

  // Note: We CAN'T ASSERT !null, as this slot may be triggered without an
  //       active window, such as during initialisation.
  if ( ! m_activeDiagramWindow.isNull() )
    m_activeDiagramWindow->setCurrentTool( t );
}


/*!
 * Minimizes the active diagram window.
 *
 * This is the same as clicking the minimize button on the window itself.
 *
 * The diagram window will no longer be active, as a minimized diagram window
 * can't be considered "active".
 *
 * Asserts that there is an active diagram window.
 * This is because this method is only meaningful when there is an active window.
 * Therefore, the user should not be allowed to trigger it when there isn't one.
 */
void DigestActionManager::minimizeWindow()
{
  Q_ASSERT( ! m_activeDiagramWindow.isNull() );
  m_activeDiagramWindow->showMinimized();
}


/*!
 * If the active diagram window is not maximized (i.e. in "normal" state) then
 * it will be maximized. Otherwise, if it is maximized, then it will be restored
 * to its previous dimensions that it had when it wasn't maximized.
 *
 * This is the same as clicking the zoom button on the window itself.
 *
 * Remember that a diagram window that is currently MINImized can't be
 * considered "active".
 *
 * Asserts that there is an active diagram window.
 * This is because this method is only meaningful when there is an active window.
 * Therefore, the user should not be allowed to trigger it when there isn't one.
 */
void DigestActionManager::zoomWindow()
{
  Q_ASSERT( ! m_activeDiagramWindow.isNull() );
  // TODO: check and clean-up:
  if ( m_activeDiagramWindow->isMaximized() ) m_activeDiagramWindow->showNormal();
  else if ( m_activeDiagramWindow->isVisible() ) m_activeDiagramWindow->showMaximized(); // FIXME
}


/*!
 * Asks the diagram manager to show or hide the element inspector as required.
 * Then it calls syncElementInspectorActionText().
 */
void DigestActionManager::toggleElementInspector()
{
  Q_ASSERT( ! m_diagramManager.isNull() );
  m_diagramManager->setElementInspectorVisible( ! m_diagramManager->isElementInspectorVisible() );
  syncElementInspectorActionText();
}


/*!
 * Raise all child windows to the front.
 * This will only affect visible windows (so minmized windows will be left as they are).
 *
 * Asserts that there is an active diagram window.
 * This is because this method is only meaningful when there is an active window.
 * Therefore, the user should not be allowed to trigger it when there isn't one.
 */
void DigestActionManager::bringAllToFront()
{
  Q_ASSERT( ! m_activeDiagramWindow.isNull() );
  foreach ( MDIChildBase* c, m_diagramManager->childWindows() ) c->widgetPtr()->raise();
}

void DigestActionManager::showAppHelp()
{
 /*
    if (!m_assistantClient)
    m_assistantClient
    = new QAssistantClient(QLibraryInfo::location(QLibraryInfo::BinariesPath), this);
    m_assistantClient->showPage(QLibraryInfo::location(QLibraryInfo::DocumentationPath)
    + "/html/" + url);
  */
  //    showHelp("designer-manual.html");
}



// TODO: remove me!
QAction *DigestActionManager::useBigIconsAction() const
{ return m_useBigIcons; }



/*!
 * It's safe to call this if there is no active window (as this is a valid case),
 * it will just return immediately.
 */
void DigestActionManager::syncToggleGridShownActionText()
{
  if ( m_activeDiagramWindow.isNull() ) return;
  m_toggleGridShownAction->setText( (m_activeDiagramWindow->gridShown()
				       ? HIDE_STR // currently visible -> allow user to HIDE it
				       : SHOW_STR)
				    + GRID_STR );
}


/*!
 * It's safe to call this if there is no active window (as this is a valid case),
 * it will just return immediately.
 */
void DigestActionManager::syncToggleSnapToGridActionText()
{
  if ( m_activeDiagramWindow.isNull() ) return;
  m_toggleSnapToGridAction->setText( TURN_STR + SNAP_TO_GRID_STR
				     + (m_activeDiagramWindow->hasSnapToGridOn()
					? OFF_STR // currently on -> allow user to turn it OFF
					: ON_STR) );
}


void DigestActionManager::syncElementInspectorActionText()
{
  Q_ASSERT( ! m_diagramManager.isNull() );
  m_toggleElementInspectorAction->setText( (m_diagramManager->isElementInspectorVisible()
					    ? HIDE_STR // currently visible -> allow user to HIDE it 
					    : SHOW_STR)
					   + ELEMENT_INSPECTOR_STR );
}
