// BASED ON: qdesigner_actions.h in qt-mac-opensource-4.0.0-b2-snapshot-20050318, located in the /tools/designer/src/designer/ sub-dir of Qt.
//           Imported on Wed Mar 30 2005 by Aidan Lane.
//           Modifications Copyright (c) CEMA, Monash University. All rights reserved.
/****************************************************************************
 **
 ** Copyright (C) 1992-2005 Trolltech AS. All rights reserved.
 **
 ** This file is part of the designer application of the Qt Toolkit.
 **
 ** This file may be distributed and/or modified under the terms of the
 ** GNU General Public License version 2 as published by the Free Software
 ** Foundation and appearing in the file LICENSE.GPL included in the
 ** packaging of this file.
 **
 ** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
 **   information about Qt Commercial License Agreements.
 ** See http://www.trolltech.com/gpl/ for GPL licensing information.
 **
 ** Contact info@trolltech.com if any conditions of this licensing are
 ** not clear to you.
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/


// TODO: CLEANUP!
// TODO: CLEANUP!
// TODO: CLEANUP!
// TODO: CLEANUP!
// TODO: CLEANUP!
// TODO: CLEANUP!
// TODO: CLEANUP!
// TODO: CLEANUP!
// TODO: CLEANUP!


#ifndef DIGESTACTIONMANAGER_H
#define DIGESTACTIONMANAGER_H

#include <QObject>
#include <QPointer>


class QAction;
class QActionGroup;

class DigestApplication;
class MDIDiagramWindow;
class MDIChildBase;


/*!
 * Manages the actions for the entire app.
 *
 * Uses signals'n'slots to communicate with DigestApplication and its
 * MDIDiagramWindows, telling them what to do when an action is triggered.
 *
 * WARNING! There may only be one instance of DigestActionManager.
 *          Because of this, other objects can use it without having to be told
 *          of its address explicitly.
 */

class DigestActionManager: public QObject
{
  Q_OBJECT
 
 public:
  DigestActionManager( DigestApplication* diagramManager );
  virtual ~DigestActionManager();

  static DigestActionManager* instance();

  DigestApplication* diagramManager() const;
  MDIDiagramWindow* activeDiagramWindow() const;

  bool saveDiagram(MDIDiagramWindow *fw);
  /* TODO: remove me if UNNEEDED
  bool readInForm(const QString &fileName);
  bool writeOutForm(MDIDiagramWindow *formWindow, const QString &fileName);
  */

  QActionGroup* fileActions() const;
  QActionGroup* recentFilesActions() const;
  QActionGroup* editActions() const;
  QActionGroup* viewActions() const;
  QActionGroup* toolActions() const { return m_toolActions; }
  QActionGroup* windowActions() const;
  QActionGroup* helpActions() const;

  QAction *useBigIconsAction() const; //TODO: remove me


  //
  // file actions
  //
  QAction* newDiagramAction() const;
  QAction* openDiagramAction() const;
  QAction* closeWindowAction() const;
  QAction* saveDiagramAction() const;
  QAction* saveDiagramAsAction() const;
  QAction* saveAllDiagramsAction() const;
  QAction* appQuitAction() const;

  //
  // edit actions
  //
  QAction* undoAction() const;
  QAction* redoAction() const;
  QAction* cutAction() const;
  QAction* copyAction() const;
  QAction* pasteAction() const;
  QAction* deleteAction() const;
  QAction* selectAllAction() const;
  QAction* bringToFrontAction()   const { return m_bringToFrontAction; }
  QAction* sendToBackAction()     const { return m_sendToBackAction; }
  QAction* bringForwardAction()   const { return m_bringForwardAction; }
  QAction* sendBackwardAction()   const { return m_sendBackwardAction; }
  QAction* appPrefsAction() const;
  QAction* showPropertiesAction() const { return m_showPropertiesAction; }

  //
  // view actions
  //
  QAction* showLabelsAction()       const { return m_showLabelsAction; }
  QAction* actualSizeAction()       const { return m_actualSizeAction; }
  QAction* zoomInAction()           const { return m_zoomInAction; }
  QAction* zoomOutAction()          const { return m_zoomOutAction; }
  QAction* toggleGridShownAction()  const { return m_toggleGridShownAction; }
  QAction* toggleSnapToGridAction() const { return m_toggleSnapToGridAction; }
  QAction* fullScreenAction()       const { return m_fullScreenAction; }


  //
  // tool actions
  //
  QAction* selectionToolAction()  const { return m_selectionToolAction; }
  QAction* zoomToolAction()       const { return m_zoomToolAction; }
  QAction* shapeToolAction()      const { return m_shapeToolAction; }
  QAction* polygonToolAction()    const { return m_polygonToolAction; }
  QAction* polylineToolAction()   const { return m_polylineToolAction; }
  QAction* textToolAction()       const { return m_textToolAction; }

  //
  // window actions
  //
  QAction* minimizeWindowAction() const;
  QAction* zoomWindowAction() const;
  QAction* toggleElementInspectorAction() const;
  QAction* bringAllToFront() const;

  //
  // help actions
  //
  QAction* appHelpAction() const;
  QAction* appAboutAction() const;


 signals:
  void useBigIcons(bool);



 protected slots:
  void setActiveDiagramWindow( MDIChildBase* child );

  void openRecentForm();
  void clearRecentFiles();

  void toggleGridShown();
  void toggleSnapToGrid();
  void increaseGridRes();
  void decreaseGridRes();
  void showProperties();

  void setCurrentTool( QAction* toolAction );

  void minimizeWindow();
  void zoomWindow();
  void toggleElementInspector();
  void bringAllToFront();

  void showAppHelp();

  void syncToggleGridShownActionText();
  void syncToggleSnapToGridActionText();
  void syncElementInspectorActionText();


 private:
  enum { MaxRecentFiles = 10 };

  void fixActionContext();
  void updateRecentFileActions();
  void addRecentFile(const QString &fileName);

  QPointer<DigestApplication> m_diagramManager;
  QPointer<MDIDiagramWindow>  m_activeDiagramWindow;

  QActionGroup* m_fileActions;
  QActionGroup* m_recentFilesActions;
  QActionGroup* m_editActions;
  QActionGroup* m_viewActions;
  QActionGroup* m_toolActions;
  QActionGroup* m_windowActions;
  QActionGroup* m_helpActions;

  QAction* m_newDiagramAction;
  QAction* m_openDiagramAction;
  QAction* m_closeWindowAction;
  QAction* m_saveDiagramAction;
  QAction* m_saveDiagramAsAction;
  QAction* m_saveAllDiagramsAction;
  QAction* m_appQuitAction;

  QAction* m_undoAction;
  QAction* m_redoAction;
  QAction* m_cutAction;
  QAction* m_copyAction;
  QAction* m_pasteAction;
  QAction* m_deleteAction;
  QAction* m_selectAllAction;
  QAction* m_bringToFrontAction;
  QAction* m_sendToBackAction;
  QAction* m_bringForwardAction;
  QAction* m_sendBackwardAction;
  QAction* m_appPrefsAction;
  QAction* m_showPropertiesAction;

  QAction* m_showLabelsAction;
  QAction* m_actualSizeAction;
  QAction* m_zoomInAction;
  QAction* m_zoomOutAction;
  QAction* m_toggleGridShownAction;
  QAction* m_toggleSnapToGridAction;
  QAction* m_fullScreenAction;

  QAction* m_selectionToolAction;
  QAction* m_zoomToolAction;
  QAction* m_shapeToolAction;
  QAction* m_polygonToolAction;
  QAction* m_polylineToolAction;
  QAction* m_textToolAction;

  QAction* m_minimizeWindowAction;
  QAction* m_zoomWindowAction;
  QAction* m_toggleElementInspectorAction;
  QAction* m_bringAllToFrontAction;

  QAction* m_appHelpAction;
  QAction* m_appAboutAction;

  //TODO: remove me:
  QAction *m_useBigIcons;
};

#endif // DIGESTACTIONMANAGER_H

