/*  -*- c++ -*-  (for Emacs)
 *
 *  digestapplication.h
 *  Nodal
 *
 *  Imported into Nodal by Aidan Lane on Thu Feb 24 2005.
 *  Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *  Original file:
 *
 *    digestapplication.h
 *    EverGreen
 *
 *    Created by Aidan Lane on Mon Jul 19 2004.
 *    Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIGESTAPPLICATION_H
#define DIGESTAPPLICATION_H


#include "mdiapplication.h"

#include <QHash>
#include <QPointer>
#include <QSqlDatabase>

#include <jni.h>

#include "digest.h" // Digest namespace
#include "digestprefsdialog.h"

class QActionGroup;
class QAction;
class QDialog;
class QMenuBar;
class QThread;

class Diagram;
class DigestActionManager;
class DigestDbModel;
class DigestDbController;
class ElementInspector;
class GuiDiagramController;
class MDIDiagramWindow;
class SettingsModel;
class SettingsController;


/*!
 * Note: DigestApplication is to make no assumptions as to which actions are
 *       available in DigestActionManager, only the groups of actions.
 *       Instead, we provide slots for which the action manager may connect
 *       to if and when required.
 */
class DigestApplication : public MDIApplication {

  Q_OBJECT

public:
  // TODO: rename this to something more intuitive - MDI view is stored as the hash key of m_managedDiagrams
  struct DiagramMvcStruct {
    DiagramMvcStruct( Diagram* model = 0,
		      QThread* controllerThreadHost = 0,
		      GuiDiagramController* cached_controller = 0 )
      : model(model),
	controllerThreadHost(controllerThreadHost),
	cached_controller(cached_controller) {}
    Diagram* model;
    QThread* controllerThreadHost;
    GuiDiagramController* cached_controller;
  };

  DigestApplication( int& argc, char** argv );
  virtual ~DigestApplication();

  bool event( QEvent* e );

  const QHash<MDIDiagramWindow*, DiagramMvcStruct>& managedDiagrams() const {
    return m_managedDiagrams;
  }

  bool isElementInspectorVisible() const;

  virtual bool childWindowCloseRequest( MDIChildBase* child );
  virtual void setActiveChild( MDIChildBase* child );

  static QString saneDefaultPath();


 signals:
  /*! Emits activeChildChanged  EVEN IF the child is non-null
   *  (it is important to know if there are no diagram windows!).
   */
  void activeChildChanged( MDIChildBase* child );

  void elementInspectorVisibilityToggled();
  
	
public slots:
  /* We only implement slots for actions that this manager is actually
   * responsible for.
   *
   * I have chosen to provide all diagram _management_ in this class (sometimes
   * telling the diagram controllers what to do), as we are the actual owners of
   * each of the model/view/controller components and the fact that
   * MDIDiagramWindow is just a view (so don't get it to do it).
   */
  void newDiagram();
  void openDiagram();
  void closeDiagram( MDIChildBase* child = 0 );
  bool saveDiagram( MDIChildBase* child = 0 );
  bool saveDiagramAs( MDIChildBase* child = 0 );
  bool saveAllDiagrams();

  void closeActiveWindow();

  void setElementInspectorVisible( bool visible );

  void showAppPrefs();
  void showAppHelp();
  void showAppAbout();
  void appQuit();


private:
  void setupUi();
  void createMenuBar();
  MDIDiagramWindow* createNewMvcSet();


private:
  void init();
  void initJvm();

  JavaVM* m_jvm;

  QSqlDatabase m_db;
  QString m_dbConnectionName;

  DigestDbModel* m_dbModel;
  DigestDbController* m_dbController;

  SettingsModel* m_settingsModel;
  SettingsController* m_settingsController;

  QHash<MDIDiagramWindow*, DiagramMvcStruct> m_managedDiagrams; // TODO: rename this to something more intuitive
  DigestActionManager* m_actionManager;

  // The following are used to point to modal-less, single instance dialogs
  // that will remain allocated until closed by user.
  QPointer<ElementInspector> m_elementInspector;
  QPointer<DigestPrefsDialog> prefsDlg;
  QPointer<QDialog>           aboutBoxDlg;

  QMenuBar* m_globalMenuBar; // application-wide / global menu bar

  QMenu* m_fileMenu;
  QMenu* m_recentFilesMenu;//TODO: remove me
  QMenu* m_editMenu;
  QMenu* m_viewMenu;
  QMenu* m_toolMenu;
  QMenu* m_windowMenu;
  QMenu* m_helpMenu;

  QString m_prevPath;
};


#endif // ! DIGESTAPPLICATION_H
