/*
 *  main.cpp
 *  Nodal
 *
 *  Imported into Nodal by Aidan Lane on Thu Feb 24, 2005.
 *  Copyright 2005 CEMA, Monash University. All rights reserved.
 *
 *  This file was originally created as part of "EverGreen", a plant modelling
 *  system that was developed as part of my (Aidan Lane's) Honours Thesis.
 *  Vist the project's web page via http://www.csse.monash.edu.au/~alane/
 *		Created by Aidan Lane on Tue Jul ? 2004.
 *		Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "digestapplication.h"


int main( int argc, char ** argv )
{
  DigestApplication a( argc, argv );
 
#if defined (Q_WS_MAC)
  /*
   * On Mac OS X, there is no top-level widget that owns all other windows.
   * The DigestApplication is a QObject on this platform, which owns a
   * parent-less menu bar.
   * Even when the last document window is closed, we still want the app to
   * stay open, with the menu-bar availble.
   */
  a.setQuitOnLastWindowClosed( false );
#endif

  return a.exec();
}
