#!/bin/sh

ORIG_PATH=$PWD

APP_NAME=Digest
APP_BUNDLE_ROOT_PATH=../../bin/$APP_NAME.app
APP_BUNDLE_CONTENTS_PATH=$APP_BUNDLE_ROOT_PATH/Contents
APP_BUNDLE_EXECUTABLE=$APP_BUNDLE_CONTENTS_PATH/MacOS/$APP_NAME
APP_BUNDLE_LIBS_PATH=$APP_BUNDLE_CONTENTS_PATH/Libraries
APP_BUNDLE_PLUGINS_PATH=$APP_BUNDLE_CONTENTS_PATH/PlugIns
APP_BUNDLE_RES_PATH=$APP_BUNDLE_CONTENTS_PATH/Resources
EXEC_LIBS_PATH=@executable_path/../Libraries

QT_PATH=`qmake -query "QT_INSTALL_PREFIX"` # as the use of QTDIR has been phased out
QT_LIBS_PATH=$QT_PATH/lib

if [ ! -d $APP_BUNDLE_LIBS_PATH ]; then
    mkdir -p $APP_BUNDLE_LIBS_PATH
fi

if [ ! -d $APP_BUNDLE_PLUGINS_PATH ]; then
    mkdir -p $APP_BUNDLE_PLUGINS_PATH
fi

if [ ! -d $APP_BUNDLE_RES_PATH ]; then
    mkdir -p $APP_BUNDLE_RES_PATH
fi


# Copy the CIDER related Jar files in to the app's bundle:
cp cider/CiderCore-0.3.0.jar     $APP_BUNDLE_LIBS_PATH
cp cider/fsa_editor.jar          $APP_BUNDLE_LIBS_PATH

# Copy the Mac-sepecific files into the app's bindle:
cp mac/Info.plist                $APP_BUNDLE_CONTENTS_PATH
cp mac/version.plist             $APP_BUNDLE_CONTENTS_PATH
cp mac/${APP_NAME}.icns          $APP_BUNDLE_RES_PATH
cp mac/${APP_NAME}Document.icns  $APP_BUNDLE_RES_PATH

# Copy our libraries in to the app's bundle:
cp ../DigestGuiCore/libDigestGuiCore.1.dylib            $APP_BUNDLE_LIBS_PATH
cp ../Gesture/libGesture.1.dylib                        $APP_BUNDLE_LIBS_PATH
cp ../GestureRecognition/libGestureRecognition.1.dylib  $APP_BUNDLE_LIBS_PATH
cp ../GestureRecognition/GestureRecognition.jar         $APP_BUNDLE_LIBS_PATH # Java
cp ../MvcCore/libMvcCore.1.dylib                        $APP_BUNDLE_LIBS_PATH
cp ../MvcDigestDb/libMvcDigestDb.1.dylib                $APP_BUNDLE_LIBS_PATH
cp ../MvcSettings/libMvcSettings.1.dylib                $APP_BUNDLE_LIBS_PATH
cp ../WidgetPack/libWidgetPack.1.dylib                  $APP_BUNDLE_LIBS_PATH
# Specific to Digest, the diagramming tool:
cp ../MvcDiagram/libMvcDiagram.1.dylib                  $APP_BUNDLE_LIBS_PATH

# Copy the Qt (release mode) libraries in to the app's bundle:
# Note: The "-n" flag should be safe here, given that the Qt libraries won't be
#       changed very often. Hence, this will speed successive calls of this script.
cp -n $QT_LIBS_PATH/libQtCore.4.dylib  $APP_BUNDLE_LIBS_PATH
cp -n $QT_LIBS_PATH/libQtGui.4.dylib   $APP_BUNDLE_LIBS_PATH
cp -n $QT_LIBS_PATH/libQtSql.4.dylib   $APP_BUNDLE_LIBS_PATH
cp -n $QT_LIBS_PATH/libQtXml.4.dylib   $APP_BUNDLE_LIBS_PATH

#TODO: strip exec


cd $APP_BUNDLE_LIBS_PATH

# Fix inter-library relationships and the app's refs to them:
for i in *.dylib
do
  # Fix the library's ID
  install_name_tool -id $EXEC_LIBS_PATH/$i $i

  # Fix the app ref to the library
  # Note: The following will fix lib refs even if the originals are located
  #       elsewhere, e.g. /Users/aidan/developer/qt/lib/libQtCore.4.dylib
  r=`otool -L ../MacOS/$APP_NAME | grep -o "[[:graph:]]*$i[[:graph:]]*"`
  if [ -n "$r" ]; then # note: $r MUST be quoted!
      # app uses library i
      install_name_tool -change $r $EXEC_LIBS_PATH/$i ../MacOS/$APP_NAME
  fi


  # Fix any plugin refs to the library
  # Note: in the following, the "No such file or directory" errors are silenced
#  for p in `ls -1 ../PlugIns/*.plugin ../PlugIns/*.dylib 2> /dev/null`
#  do
#    r=`otool -L $p | grep -o "[[:graph:]]*$i[[:graph:]]*"`
#    if [ -n "$r" ]; then # note: $r MUST be quoted!
#        # plugin p uses library i
#        install_name_tool -change $r $EXEC_LIBS_PATH/$i $p
#    fi
#  done


  # Fix every possible inter-library relationship
  for j in *.dylib
  do
    if [ $i != $j ]; then
	# Note: The following will fix lib refs even if the originals are located
	#       elsewhere, e.g. ~/developer/qt/lib/libQtCore.4.dylib
	r=`otool -L $i | grep -o "[[:graph:]]*$j[[:graph:]]*"`
	if [ -n "$r" ]; then # note: $r MUST be quoted!
	    # i uses j
	    install_name_tool -change $r $EXEC_LIBS_PATH/$j $i
	fi
    fi   
  done
done

cd $ORIG_PATH