/*  -*- c++ -*-  (for Emacs)
 *
 *  diagrameditor.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 14 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIAGRAMEDITOR_H
#define DIAGRAMEDITOR_H


#include <QWidget>
#include "MvcDiagram/abstractdiagramview.h"
#include "MvcDigestDb/abstractdigestdbview.h"
#include "MvcSettings/abstractsettingsview.h"

#include <QEvent> // TODO: remove me!
#include <QPicture>
#include <QPointer>
#include <QTime>

#include <jni.h>

#include "Gesture/strokelist.h"
#include "DigestGuiCore/strokespainterpath.h"

#include "digest.h"


class AbstractDiagramElement;
class AbstractRecogniser;


class DiagramEditor : public QWidget,
		      public AbstractDiagramView,
		      public AbstractDigestDbView,
		      public AbstractSettingsView {

  Q_OBJECT

public:
  DiagramEditor( JavaVM* jvm, QWidget* parent = 0 );
  DiagramEditor( AbstractController* diagramController,
		 AbstractController* digestDbController,
		 AbstractController* settingsController,
		 JavaVM* jvm,
		 QWidget* parent = 0 );

  QSize sizeHint() const;

  Digest::Tool currentTool() const { return m_currentTool; }
  void setCurrentTool( Digest::Tool tool );


public slots:
  virtual void copy();
  virtual void cut();
  virtual void del();
  virtual void paste();
  virtual void selectAll();


protected slots:
  virtual bool tryBeginElementEditing( AbstractElement* );
  virtual void currentElementEditingFinished();


protected:

  // TODO: remove me!
  enum GestureType {
    UnknownGesture,
    CircleGesture,
    LineGesture,
    SquareGesture,
  };

  virtual void customEvent( QEvent* );

  virtual void diagramResetEvent( VEvent* );
  virtual void elementAddedEvent( VElementEvent* );
  virtual void elementRemovedEvent( VElementEvent* );
  virtual void elementAttributeAddedEvent( VElementAttributeEvent* );
  virtual void elementAttributeRemovedEvent( VElementAttributeEvent* );
  virtual void elementAttributeDataChangedEvent( VElementAttributeEvent* );
  virtual void elementSelectionChangedEvent( VElementSelectionChangedEvent* );
  virtual void elementSetOrderChangedEvent( VElementSetOrderChangedEvent* );

  virtual void settingsResetEvent( VEvent* );
  virtual void settingsValueChangedEvent( VSettingsValueChangedEvent* );

  virtual void digestDbResetEvent( VEvent* );
  virtual void trainedRecogsEvent( VTrainedRecogsEvent* );

  virtual void keyPressEvent( QKeyEvent* );
  virtual void mouseDoubleClickEvent( QMouseEvent* );
  virtual void mousePressEvent( QMouseEvent* );
  virtual void mouseReleaseEvent ( QMouseEvent* );
  virtual void mouseMoveEvent( QMouseEvent* );
  virtual void tabletEvent( QTabletEvent* );

  virtual void paintEvent( QPaintEvent* );

  virtual void selectionPress( const QPointF& pos, Qt::KeyboardModifiers modifiers );
  virtual void selectionRelease();
  virtual void selectionMove( const QPointF& pos );

  virtual QPicture buildElementPicture( const AbstractElement* element ) const;

  AbstractElement* findElementAt( const QPointF& pos ) const;

  AbstractElement* addNewElement( int type );
  AbstractElementAttribute* addNewElementAttribute( int type,
						       AbstractElement* element );

  virtual void refreshRecogniser();
  virtual void recogniseCurrentStroke();

private:
  void init();

  void elementAttributeModifiedWorker( AbstractElement* e,
				       AbstractElementAttribute* a );

  void beginStroking( const StrokePoint& pt );
  void endStroking();
  void addPointToStroke( const StrokePoint& pt );

  JavaVM* m_jvm;

  Digest::Tool  m_currentTool;
  bool          m_mouseIsMovingSelection;
  QPointF       m_selectionMoveStartPos;
  QHash<AbstractElement*, QPointF> m_elementOriginsBeforeMove;

  bool   m_stroking;
  Stroke m_currentStroke;
  QTime  currentStrokeTime;
  StrokesPainterPath m_currentStrokePath;

  AbstractRecogniser* m_recogniser;
  int                 m_recogniserId;

  QPointer<QWidget> m_currentElementEditor;
  QPointer<AbstractElement> m_currentElementInEdit;

  // Caches:
  QHash<AbstractElement*, QPicture> c_elementPictures;
};


#endif  // ! DIAGRAMEDITOR_H
