/*  -*- c++ -*-  (for Emacs)
 *
 *  digestprefsdialog.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Aug 25 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIGESTPREFSDIALOG_H
#define DIGESTPREFSDIALOG_H


#include <QDialog>

#include "MvcSettings/abstractsettingsview.h"
#include "MvcDigestDb/abstractdigestdbview.h"

#include "ui_digestprefsdialogform.h"


class DigestPrefsDialog : public QDialog,
			  public AbstractSettingsView,
			  public AbstractDigestDbView {

  Q_OBJECT

public:
  DigestPrefsDialog( AbstractController* settingsController,
		     AbstractController* digestDbController,
		     QWidget* parent = 0, Qt::WindowFlags flags = 0 );


protected:
  void customEvent( QEvent* );

  void settingsResetEvent( VEvent* );

  void digestDbResetEvent( VEvent* );
  void trainedRecogsEvent( VTrainedRecogsEvent* );


private slots:
  void on_recogGroupBox_toggled( bool on );
  void on_recogComboBox_activated( int index );
  void on_closePushButton_clicked();


private:
  void refreshRecogComboBox();

  Ui::DigestPrefsDialogForm m_ui;
};


#endif // ! DIGESTPREFSDIALOG_H
