/*
 *  elementinspector.cpp
 *  Nodal
 *
 *  Imported into Nodal by Aidan Lane on Thu Feb 24 2005.
 *  Modifications Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *
 *  Original file:
 *
 *    nodeinspector.cpp
 *    EverGreen
 *
 *    Created by Aidan Lane on Wed Jul 14 2004.
 *    Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "elementinspector.h"

#include <QLayout>


/*!
 * Constructs an element inspector with the given \em parent and \em flags.
 */
ElementInspector::ElementInspector( QWidget* parent, Qt::WindowFlags flags )
  : QDialog(parent, flags),
    AbstractDiagramView(this)
{
  setupUi();
}


/*!
 * This method performs tasks such as connecting widget signals to custom slots,
 * adding menu bar items, creating toolbars and so forth, some of which probably
 * should be handled by Qt Designer .ui files, but are currently not supported
 * (using Qt4.0 beta2).
 *
 * This is also used for other misc user interface initialisation.
 *
 * This method should be called immediately after setupUi().
 */
void ElementInspector::setupUi()
{
  if ( layout() != 0 )
    layout()->setMargin(0); // remove the unneeded margin
}


/*!
 * Passes event onto QDialog and then emits visibilityToggled().
 */
void ElementInspector::showEvent( QShowEvent* event )
{
  QDialog::showEvent( event );
  emit visibilityToggled();
}


/*!
 * Passes event onto QDialog and then emits visibilityToggled().
 */
void ElementInspector::hideEvent( QHideEvent* event )
{
  QDialog::hideEvent( event );
  emit visibilityToggled();
}


/*!
 */
void ElementInspector::elementSelectionChangedEvent( VElementSelectionChangedEvent* /*event*/ )
{
  // TODO: implement me!
}
