/*  -*- c++ -*-  (for Emacs)
 *
 *  elementinspector.h
 *  Nodal
 *
 *  Imported into Nodal by Aidan Lane on Thu Feb 24 2005.
 *  Modifications Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *  Original file:
 *
 *    nodeinspector.h
 *    EverGreen
 *
 *    Created by Aidan Lane on Wed Jul 14 2004.
 *    Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */


#ifndef ELEMENTINSPECTOR_H
#define ELEMENTINSPECTOR_H


#include <QDialog>
#include "MvcDiagram/abstractdiagramview.h"


class ElementInspector : public QDialog, public AbstractDiagramView {

  Q_OBJECT

public:
  ElementInspector( QWidget* parent = 0, Qt::WindowFlags flags = 0 );


signals:
  void visibilityToggled();  


protected:
  void showEvent( QShowEvent* e );
  void hideEvent( QHideEvent* e );

  inline virtual void customEvent( QEvent* e ) {
    VEvent* ve = dynamic_cast<VEvent*>(e); // slow :-(
    if ( ve != 0 ) dispatchEvent(ve);
  }

  void elementSelectionChangedEvent( VElementSelectionChangedEvent* );


private:
  void setupUi();
};


#endif // ! ELEMENTINSPECTOR_H
