/*
 *  mdidiagramwindow.cpp
 *  Nodal
 *
 *  Imported into Nodal by Aidan Lane on Thu Feb 24 2005.
 *  Modifications Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *  Original file:
 *
 *    projectgraphview.cpp
 *    EverGreen
 *
 *    Created by Aidan Lane on Tue Jul 13 2004.
 *    Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "mdidiagramwindow.h"

#include <QDebug> // TODO: remove me
#include <QToolBar>

#include "MvcDiagram/diagram.h"
#include "MvcDiagram/diagramcontroller.h"
#include "MvcDigestDb/digestdbcontroller.h"
#include "MvcSettings/settingsmodel.h"
#include "MvcSettings/settingscontroller.h"

#include "digestactionmanager.h"
#include "diagrameditor.h"
#include "guidiagramcontroller.h"
#include "toolchooser.h"

#define DEFAULT_GRID_SHOWN      true
#define DEFAULT_SNAP_TO_GRID_ON true



//TODO: move me to another file?
#include <QPainter>
#include <QScrollArea>
class SuperScrollArea : public QScrollArea {
public:
  SuperScrollArea( QWidget* parent = 0 )
    : QScrollArea(parent) {}
  virtual void centerWidget()
  {
    Q_ASSERT( viewport() != 0 );

    // It's possible that the widget is null... only act if it isn't.
    if ( widget() != 0 )
      {
	const QSize& wSize = widget()->size();
	const QSize& vSize = viewport()->size();
	QPoint pos( widget()->pos() ); // begin with widget's pos - MAY change it
	if ( wSize.width() < vSize.width() )
	  pos.setX( (vSize.width() - wSize.width()) / 2 );
	if ( wSize.height() < vSize.height() )
	  pos.setY( (vSize.height() - wSize.height()) / 2 );
	widget()->move( pos );
      }
  }
protected:
  // Draw grey background
  virtual void paintEvent( QPaintEvent* event )
  {
    // TODO: perhaps make the background colour adjustable?
    static QPen pen( Qt::gray );
    static QBrush brush( Qt::gray );

    QScrollArea::paintEvent( event );

    Q_ASSERT( viewport() != 0 );
    QPainter p( viewport() );
    p.setPen( pen );
    p.setBrush( brush );
    p.drawRect( 0, 0, viewport()->width()-1, viewport()->height()-1 );
  }
  // Centre the viewport inside the scroll area
  // TODO: think of a better way to do this!
  virtual void resizeEvent( QResizeEvent* event )
  {
    setUpdatesEnabled( false );
    QScrollArea::resizeEvent( event );
    centerWidget();
    setUpdatesEnabled( true );
  }
  virtual void scrollContentsBy( int dx, int dy )
  {
    setUpdatesEnabled( false );
    QScrollArea::scrollContentsBy( dx, dy );
    centerWidget();
    setUpdatesEnabled( true );
  }
};




/*!
 * Constructs a MDI Diagarm window with the given \em parent and attaches itself
 * to the given controllers.
 */
MDIDiagramWindow::MDIDiagramWindow( AbstractController* diagramController,
				    AbstractController* digestDbController,
				    AbstractController* settingsController,
				    DigestApplication* app,
				    JavaVM* jvm,
				    QWidget* parent )
  : MDIChild<QMainWindow, DigestApplication>(app, parent),
    AbstractDiagramView(this),
    AbstractDigestDbView(this),
    AbstractSettingsView(this),
    m_jvm(jvm),
    m_scrollArea(0),
    m_diagramEditor(0)
{
  initUi();

  Q_ASSERT( diagramController != 0 );
  Q_ASSERT( digestDbController != 0 );
  Q_ASSERT( settingsController != 0 );
  diagramController->attachView( static_cast<AbstractDiagramView*>(this) );
  digestDbController->attachView( static_cast<AbstractDigestDbView*>(this) );
  settingsController->attachView( static_cast<AbstractSettingsView*>(this) );
}


void MDIDiagramWindow::initUi()
{
  /* No background needs to be drawn for the window at all, since child widgets
   * cover the entire window. This reduces redraw time and possibly even flicker
   * when the window is resized.
   *
   * Note: Don't set Qt::WA_NoSystemBackground, as that disabled double-buffering
   */
  setAttribute( Qt::WA_OpaquePaintEvent );


  /*
   * Create the toolbar.
   */
  QToolBar* tb = new QToolBar( this );
  tb->setMovable( false );

  m_toolChooser = new ToolChooser( tb );
  tb->addWidget( m_toolChooser );
  connect( m_toolChooser,
	   SIGNAL(currentToolChanged(Digest::Tool)),
	   SLOT(setCurrentTool(Digest::Tool)) );

  addToolBar( tb );


  /*
   * Create the central widget - scrollable diagram editor.
   *
   * Note: We keep the scroll bars always on for the following reasons:
   *       1. The horizontal bar contains a zoom selector / combo box.
   *       2. Given 1., the vertical bar is kept on for consistency.
   *       3. Having a permanent horizontal scroll bar ensures that the
   *          scroll-down arrow on the vertical bar isn't hidden by MacOS X's
   *          resize grip / tab.
   *       4. If they wern't always on, then they would "pop" on and off the
   *          screen as space is made available and taken away, which can be
   *          very annoying in this type of app.
   */
  m_scrollArea = new SuperScrollArea( this );
  m_scrollArea->setFrameShape( QFrame::NoFrame );
  m_scrollArea->setHorizontalScrollBarPolicy( Qt::ScrollBarAlwaysOn );
  m_scrollArea->setVerticalScrollBarPolicy( Qt::ScrollBarAlwaysOn );

  // Note: We set the diagram editor's controller when we receive our
  //       changeControllerEvent.
  m_diagramEditor = new DiagramEditor( m_jvm, m_scrollArea );
  m_diagramEditor->setCurrentTool( m_toolChooser->currentTool() );
  m_scrollArea->setWidget( m_diagramEditor );

  setCentralWidget( m_scrollArea );
}


/*!
 * Show a diagram settings sheet (on Mac OS X) or dialog (all other OSs).
 */
// TODO: disable the diagram view and players first (not the entire dialog, as that would also disable the sheet!
// TODO: ensure that there is only one of there dialogs per window
// TODO: disable menu actions that are assocated with this window!
void MDIDiagramWindow::showProperties()
{
  /* TODO: re-implement me!
  if ( isVisible() )
    {
  // TODO: DOC me
#if defined(Q_WS_MAC)
      settingsDialog = new DiagramSettings( this, Qt::Sheet | Qt::MSWindowsFixedSizeDialogHint | Qt::WindowTitleHint | Qt::WindowSystemMenuHint );//TODO: fix flags!
#else
  settingsDialog = new DiagramSettings( "Playback Settings", this );
#endif
  Q_CHECK_PTR( settingsDialog );
  settingsDialog->show();
    }
  */
}


Digest::Tool MDIDiagramWindow::currentTool() const
{
  Q_ASSERT( m_diagramEditor != 0 );
  return m_diagramEditor->currentTool();
}


/*!
 * Set the Diagram editor's current tool.
 */
// TODO: update the tool chooser if they didn't send the request!
void MDIDiagramWindow::setCurrentTool( Digest::Tool tool )
{
  Q_ASSERT( m_diagramEditor != 0 );
  m_diagramEditor->setCurrentTool( tool );
}


bool MDIDiagramWindow::gridShown() const
{
  // TODO: implement me!
  return true;
}


// diagram editor CAN be null - just wont be updated
// TODO: when creating the diagram editor, use this value
void MDIDiagramWindow::setGridShown( bool /*shown*/ )
{
  // TODO: implement me!
}


bool MDIDiagramWindow::hasSnapToGridOn() const
{
  // TODO: implement me!
  return true;
}



// diagram editor CAN be null - just wont be updated
// TODO: when creating the diagram editor, use this value
void MDIDiagramWindow::setSnapToGridOn( bool /*on*/ )
{
  // TODO: implement me!
}


/*!
 * Ensures that the diagram editor is re-painted. Paints intermittently without this.
 */
void MDIDiagramWindow::showEvent( QShowEvent* event )
{
  MDIChild<QMainWindow, DigestApplication>::showEvent( event );
  // TODO: implement me!

  // TODO: remove the need for this:
  Q_ASSERT( m_scrollArea != 0 );
  m_scrollArea->centerWidget();
}


/*!
 * Calls AbstractDiagramView::dispatchEvent(),
 * AbstractDigestDbView::dispatchEvent(),
 * or AbstractSettingsView::dispatchEvent(),
 * depending on the event sender's module ID.
 */
void MDIDiagramWindow::customEvent( QEvent* e )
{
  VEvent* ve = dynamic_cast<VEvent*>(e); // slow :-(
  if ( ve != 0 )
    {
      Q_ASSERT( ve->sender() != 0 );
      MvcModuleId_t m = ve->sender()->moduleId();
      if ( m == AbstractDiagramView::classModuleId() )
	AbstractDiagramView::dispatchEvent(ve);
      else if ( m == AbstractDigestDbView::classModuleId() )
	AbstractDigestDbView::dispatchEvent(ve);
      else if ( m == AbstractSettingsView::classModuleId() )
	AbstractSettingsView::dispatchEvent(ve);
    }
}


/*!
 * Sets the diagram controller that is to be used by the MDI Diagram window and
 * its Diagram editor.
 */
void MDIDiagramWindow::changeDiagramControllerEvent( VChangeControllerEvent* event )
{
  /* Warning: We can't simply post a VChangeControllerEvent to the diagram
   *          editor, as it needs to be detached from the current controller
   *          (if there is one) and attached to the new controler (again,
   *          if there is one).
   */
  Q_ASSERT( event != 0 );
  Q_ASSERT( m_diagramEditor != 0 );
  AbstractController* currentController = m_diagramEditor->diagramController();
  AbstractController* newController = event->controller();
  if ( newController != currentController ) { // as the following is VERY costly:
    if ( currentController != 0 )
      currentController->detachView( static_cast<AbstractDiagramView*>(m_diagramEditor) );
    if ( newController != 0 )
      newController->attachView( static_cast<AbstractDiagramView*>(m_diagramEditor) );
  }
}


/*!
 * Resets the MDI main window.
 *
 * This includes the window's title and it's modification state marker.
 *
 * The diagram editor will look after itself when it receives its own reset
 * event.
 *
 * See also renamedEvent() and modifiedStateChangedEvent().
 */
void MDIDiagramWindow::diagramResetEvent( VEvent* )
{
  setWindowTitle( ((diagram()==0) ? QString() : diagram()->name()) + "[*]" );
  setWindowModified( diagram() != 0 && diagram()->isModified() );
}


/*!
 * Updates the window's title to reflect the Diagram document's name.
 *
 * Asserts that the \em event is non-null.
 */
void MDIDiagramWindow::renamedEvent( VRenamedEvent* event )
{
  // Note: "[*]" is an invisible placeholder to facilitate setWindowModified
  Q_ASSERT( event != 0 );
  setWindowTitle( event->name() + "[*]");
}


/*!
 * Updates the window's modified marker (a dot on the close button on Mac OS X
 * and an asterisk in the title on Windows) to reflect the Diagram document's
 * modification state.
 *
 * Asserts that the \em event is non-null.
 */
void MDIDiagramWindow::modifiedStateChangedEvent( VModifiedStateChangedEvent* event )
{
  Q_ASSERT( event != 0 );
  setWindowModified( event->documentModified() );
}


/*!
 * Sets the settings controller that is to be used by the MDI diagram window and
 * its Settings editor.
 */
void MDIDiagramWindow::changeSettingsControllerEvent( VChangeControllerEvent* event )
{
  /* Warning: We can't simply post a VChangeControllerEvent to the diagram
   *          editor, as it needs to be detached from the current controller
   *          (if there is one) and attached to the new controler (again,
   *          if there is one).
   */
  Q_ASSERT( event != 0 );
  Q_ASSERT( m_diagramEditor != 0 );
  AbstractController* currentController = m_diagramEditor->settingsController();
  AbstractController* newController = event->controller();
  if ( newController != currentController ) { // as the following is VERY costly:
    if ( currentController != 0 )
      currentController->detachView( static_cast<AbstractDiagramView*>(m_diagramEditor) );
    if ( newController != 0 )
      newController->attachView( static_cast<AbstractDiagramView*>(m_diagramEditor) );
  }
}


void MDIDiagramWindow::settingsResetEvent( VEvent* )
{
  // TODO: impl me!
}


/*!
 * Sets the digestDb controller that is to be used by the MDI diagram window and
 * its DigestDb editor.
 */
void MDIDiagramWindow::changeDigestDbControllerEvent( VChangeControllerEvent* event )
{
  /* Warning: We can't simply post a VChangeControllerEvent to the diagram
   *          editor, as it needs to be detached from the current controller
   *          (if there is one) and attached to the new controler (again,
   *          if there is one).
   */
  Q_ASSERT( event != 0 );
  Q_ASSERT( m_diagramEditor != 0 );
  AbstractController* currentController = m_diagramEditor->digestDbController();
  AbstractController* newController = event->controller();
  if ( newController != currentController ) { // as the following is VERY costly:
    if ( currentController != 0 )
      currentController->detachView( static_cast<AbstractDiagramView*>(m_diagramEditor) );
    if ( newController != 0 )
      newController->attachView( static_cast<AbstractDiagramView*>(m_diagramEditor) );
  }
}


void MDIDiagramWindow::digestDbResetEvent( VEvent* )
{
  // TODO: impl me!
}
