/*  -*- c++ -*-  (for Emacs)
 *
 *  mdidiagramwindow.h
 *  Nodal
 *
 *  Imported into Nodal by Aidan Lane on Thu Feb 24 2005.
 *  Modifications Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *  Original file:
 *
 *    projectgraphview.h
 *    EverGreen
 *
 *    Created by Aidan Lane on Tue Jul 13 2004.
 *    Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef MDIDIAGRAMWINDOW_H
#define MDIDIAGRAMWINDOW_H


#include <QMainWindow>
#include "digestapplication.h"
#include "MvcDiagram/abstractdiagramview.h"
#include "MvcDigestDb/abstractdigestdbview.h"
#include "MvcSettings/abstractsettingsview.h"

#include <jni.h>

class ToolChooser;
class SuperScrollArea;
class DiagramEditor;


/*!
 * WARNING:
 *
 * See MDIChild (in mdiapplication.h) for why we need to specify the manager's class.
 *
 * Also, we don't want to make this class a template with the manager's class as
 * a parameter, as we use Qt's signals'n'slots, which requires that this not be
 * a template.
 */
class MDIDiagramWindow : public MDIChild<QMainWindow, DigestApplication>,
			 public AbstractDiagramView,
			 public AbstractDigestDbView,
			 public AbstractSettingsView {

  Q_OBJECT

public:
  MDIDiagramWindow( AbstractController* diagramController,
		    AbstractController* digestDbController,
		    AbstractController* settingsController,
		    DigestApplication* app,
		    JavaVM* jvm,
		    QWidget* parent = 0 );

  Digest::Tool currentTool() const;
  bool gridShown() const;
  bool hasSnapToGridOn() const;


public slots: 
  void setCurrentTool( Digest::Tool tool );
  void setGridShown( bool shown );
  void setSnapToGridOn( bool on );

  void showProperties();


protected:
  void showEvent( QShowEvent* );

  void customEvent( QEvent* );

  void changeDiagramControllerEvent( VChangeControllerEvent* );
  void diagramResetEvent( VEvent* );
  void renamedEvent( VRenamedEvent* );
  void modifiedStateChangedEvent( VModifiedStateChangedEvent* );

  void changeDigestDbControllerEvent( VChangeControllerEvent* );
  void digestDbResetEvent( VEvent* );

  void changeSettingsControllerEvent( VChangeControllerEvent* );
  void settingsResetEvent( VEvent* );


private:
  void initUi();

  JavaVM*           m_jvm;
  ToolChooser*      m_toolChooser;
  SuperScrollArea*  m_scrollArea;
  DiagramEditor*    m_diagramEditor;

  //TODO: re-implement me: ProjectSettings* settingsDialog;
  // TODO: rename the ProjectSettings class to something like "ProjectSettingsDialog"
};



#endif // ! MDIDIAGRAMWINDOW_H
