/*  -*- c++ -*-  (for Emacs)
 *
 *  toolchooser.h
 *  Digest
 * 
 *  Created by Aidan Lane on Wed Aug 24 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

// TODO: break me up into separate header and impl files!

#ifndef TOOLCHOOSER_H
#define TOOLCHOOSER_H


#include <QWidget>

#include "digest.h"

#include <QIcon>
#include <QLabel>
#include <QVBoxLayout>


// TODO: remove the need for the following class!
// Reduces the size of the tabs to fit the tab icons without leaving room for text
#include <QTabBar> // TODO: remove me!
class ToolTabBar : public QTabBar {
public:
  ToolTabBar( QWidget* parent = 0 ) : QTabBar(parent) {}
protected:
  QSize tabSizeHint( int index ) const {
    // TODO: remove the need for the following hack!
    return QSize( (index==count()-1)
		  ? 31
		  : 29, QTabBar::tabSizeHint(index).height()+2 ); // +2 -> VCentre icons
  }
};

// TODO: add options for showing text and so forth like for QActions in toolbars!
class ToolChooser : public QWidget {

  Q_OBJECT

public:
  ToolChooser( QWidget* parent = 0 ) : QWidget(parent)
  {
    QVBoxLayout* layout = new QVBoxLayout( this );
    layout->setMargin( 3 );

    tabBar = new ToolTabBar( this );
    tabBar->addTab( QIcon(":images/tools/SelectionTool.png"), QString() );
    tabBar->addTab( QIcon(":images/tools/ZoomTool.png"), QString() );
    tabBar->addTab( QIcon(":images/tools/ShapeTool.png"), QString() );
    tabBar->addTab( QIcon(":images/tools/PolygonTool.png"), QString() );
    tabBar->addTab( QIcon(":images/tools/PolylineTool.png"), QString() );
    tabBar->addTab( QIcon(":images/tools/TextTool.png"), QString() );
    layout->addWidget( tabBar );

    connect( tabBar,
	     SIGNAL(currentChanged(int)), SLOT(onTabBarCurrentChanged(int)) );

#if 0 // TODO: make the following optional
    QLabel* label = new QLabel( this );
    QFont f = label->font();
    f.setPointSize( 11 ); // TODO: get this from QStyle!!!
    label->setFont( f );
    label->setAlignment( Qt::AlignHCenter );
    label->setText( tr("Tool Mode") ); // same string as what "Preview" on Mac OS X uses
    layout->addWidget( label );
#endif
  }

  Digest::Tool currentTool() const {
    Q_ASSERT( tabBar != 0 );
    return (Digest::Tool )tabBar->currentIndex();
  }


signals:
  void currentToolChanged( Digest::Tool tool );


public slots:
  void setCurrentTool( Digest::Tool tool ) {
    Q_ASSERT( tabBar != 0 );
    tabBar->setCurrentIndex( (int)tool );
  }


private slots:
  void onTabBarCurrentChanged( int index ) {
    emit currentToolChanged( (Digest::Tool)index );
  }


private:
  ToolTabBar* tabBar;
};



#endif  // ! TOOLCHOOSER_H
