/*  -*- c++ -*-  (for Emacs)
 *
 *  abstractguicomponent.h
 *  Digest
 * 
 *  Created by Aidan Lane on Fri Jul 01 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ABSTRACTGUICOMPONENT_H
#define ABSTRACTGUICOMPONENT_H


#include <QWidget>

#include <jni.h>

class QSqlDatabase;
class QWidget;


// TODO: re-write the following documentation!
/*!
 * \brief The AbstractGuiComponent class provides an abstract interface for
 *        pluggable GUI components.
 *
 * This class provides a simple interface that is used by the GUI libraries.
 * It separates the component's implementation from the calling application.
 * Hence, as long as the sub-class is not modified, the ABI won't break when
 * the rest of the component is modified.
 *
 * The only file that this includes is QWidget's header.
 * Hence, code expansion should be minimal as it's included by the calling
 * application.
 *
 * Note: The Java Virtual Machine \em jvm may or may not be used - some
 *       components such as the TrainingAssistant may use it, as recogniser
 *       trainers can be written in Java. Hence, to keep the system generic
 *       and open to more uses of Java, the \em jvm must always be passed.
 */
class AbstractGuiComponent : public QObject {

  Q_OBJECT

public:
  AbstractGuiComponent( JavaVM* jvm,
			QWidget* parent = 0, Qt::WindowFlags flags = 0 )
    : QObject(parent) { Q_UNUSED(jvm); Q_UNUSED(flags); }
  virtual ~AbstractGuiComponent() {}

  virtual const QByteArray& key() const = 0;

  virtual bool isRootWidgetVisible() const = 0;

  virtual bool deleteOnCloseEnabled() const = 0;
  virtual void setDeleteOnClose( bool enable ) = 0;


signals:
  void rootWidgetVisibilityToggled();
  void request( const QString& message );


public slots:
  virtual void setRootWidgetVisible( bool visible ) = 0;
  virtual void showRootWidget( Qt::WindowStates windowState = Qt::WindowNoState ) = 0;
  virtual void hideRootWidget() = 0;
  virtual void execMessage( const QString& message ) = 0;
};


#endif  // ! ABSTRACTGUICOMPONENT_H
