/*  -*- c++ -*-  (for Emacs)
 *
 *  categoryitemmodel.h
 *  Digest
 * 
 *  Created by Aidan Lane on Wed Jul 20 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef CATEGORYITEMMODEL_H
#define CATEGORYITEMMODEL_H


#include <QAbstractItemModel>
#include "MvcDigestDb/abstractdigestdbview.h"

#include <QHash>


class CategoryItemModel : public QAbstractItemModel, public AbstractDigestDbView {

  Q_OBJECT

public:
  struct CategoryItem;

  // Note: This isn't called "ItemType", as it's designed for external use.
  enum IndexType {
    RootIndex,
    LibraryIndex,
    ClassIndex,
    CollectionIndex
  };

  enum ModelFlag {
    ItemsAreSelectable  = 0x1, /*! Visually indicates that an item is selected. */
    ItemsAreEditable    = 0x2, /*! Enables the editing of item labels.          */
    ItemsAreCheckable   = 0x4, /*! Note: Not affected by ItemsAreEditable.      */
    ItemsAreDropEnabled = 0x8  /*! Allows dropping of gestrues onto categories. */
  };
  Q_DECLARE_FLAGS( ModelFlags, ModelFlag ); // typesafe flags


  CategoryItemModel( QObject* parent = 0 );
  CategoryItemModel( DigestDbController* controller, QObject* parent = 0 );
  virtual ~CategoryItemModel();

  inline ModelFlags modelFlags();
  void setModelFlags( ModelFlags flags );

  CategoryItemModel::IndexType indexType( const QModelIndex& index ) const;
  int indexDatabaseId( const QModelIndex& index ) const;

  QModelIndex libraryIndex() const { return c_libraryIndex; }

  virtual Qt::ItemFlags flags( const QModelIndex& index ) const;
  virtual int rowCount( const QModelIndex& parent = QModelIndex() ) const;
  virtual int columnCount( const QModelIndex& parent = QModelIndex() ) const;

  virtual QVariant headerData( int section, Qt::Orientation orientation,
			       int role = Qt::DisplayRole ) const;

  virtual QModelIndex parent( const QModelIndex& index ) const;

  virtual QModelIndex index( int row, int column,
			     const QModelIndex& parent = QModelIndex() ) const;

  virtual QVariant data( const QModelIndex& index,
			 int role = Qt::DisplayRole ) const;

  virtual bool setData( const QModelIndex& index, const QVariant& value,
			int role = Qt::EditRole );

  Qt::DropActions supportedDropActions() const;
  virtual QStringList mimeTypes() const;
  virtual bool dropMimeData( const QMimeData* data, Qt::DropAction action,
			     int row, int column, const QModelIndex& index );

  QModelIndexList checkedIndexes() const;
  QString gestureQueryForIndexes( const QModelIndexList& indexes ) const;
  QString gestureQueryForCheckedIndexes() const;

  bool isReady() const { return m_ready; } // hacky


protected:
  DEFINE_CUSTOM_VIEWEVENT_HANDLER
  virtual void resetEvent( VEvent* );
  virtual void classesEvent( VClassesEvent* );
  virtual void collectionsEvent( VCollectionsEvent* );

  void resetModel();
  QModelIndex index( CategoryItem* item ) const;

  QModelIndexList checkedIndexes( CategoryItem* parent ) const;


private:
  void init();

  // Temporary state:
  CategoryItem* m_rootItem;
  ModelFlags    m_modelFlags;
  bool          m_ready;

  // Note: we must keep these two separate as their IDs will overlap
  QHash<int, CategoryItem*> m_classIdToItem;
  QHash<int, CategoryItem*> m_collectionIdToItem;

  // Caches:
  CategoryItem* c_libraryItem;
  QModelIndex   c_libraryIndex; // ok to cache - never leaves row 0, column 0
};

Q_DECLARE_OPERATORS_FOR_FLAGS( CategoryItemModel::ModelFlags );


/*!
 * Retruns the category item model's flags.
 *
 * Not to be confused with the version for individual items,
 * flags(const QModelIndex&).
 *
 * Defaults to: ItemsAreSelectable | ItemsAreEditable
 */
CategoryItemModel::ModelFlags CategoryItemModel::modelFlags() {
  return m_modelFlags;
}


#endif  // ! CATEGORYITEMMODEL_H
