/*  -*- c++ -*-  (for Emacs)
 *
 *  gesturequerymodel.h
 *  Digest
 * 
 *  Created by Aidan Lane on Tue Jul 05 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GESTUREQUERYMODEL_H
#define GESTUREQUERYMODEL_H


#include <QSqlQueryModel>
#include "MvcDigestDb/abstractdigestdbview.h"

#include <QBrush>
#include <QPen>
#include <QPixmap>
#include <QSize>

class DigestDbModel;


class GestureQueryModel : public QSqlQueryModel, public AbstractDigestDbView {

  Q_OBJECT
  Q_PROPERTY( QSize thumbnailSize READ thumbnailSize WRITE setThumbnailSize )


public:
  GestureQueryModel( QObject* parent = 0 );
  GestureQueryModel( DigestDbController* controller, QObject* parent = 0 );

  virtual Qt::ItemFlags flags( const QModelIndex& index ) const;
  virtual QVariant data( const QModelIndex& index, int role = Qt::DisplayRole ) const;
  virtual QStringList mimeTypes() const;
  virtual QMimeData* mimeData( const QModelIndexList& indexes ) const;

  QModelIndex findIndexOfGesture( int gestureId );
  int rowGestureId( int row ) const;

  const QSize& thumbnailSize() const;


signals:
  void thumbnailSizeChanged( const QSize& size );


public slots:
  virtual void setThumbnailSize( const QSize& size );
  void setThumbnailSize( int w, int h );


protected:
  DEFINE_CUSTOM_VIEWEVENT_HANDLER
  virtual void resetEvent( VEvent* );
  virtual void gesturesEvent( VGesturesEvent* );

  virtual QPixmap fetchThumbnail( int gestureId ) const;
  virtual QPixmap generateThumbnail( int gestureId ) const;
  virtual QPixmap generateThumbnailTile( const QSize& size ) const;


private:
  void init();

  QSize   m_thumbnailSize;
  QPen    m_strokesPen;
  QPen    m_tilePen;
  QBrush  m_tileBrush;
  float   m_strokeWidth;
  int     m_tileMargin;

  // Caches:
  mutable QPixmap c_thumbnailTile;
};


#endif  // ! GESTUREQUERYMODEL_H
